/*
 * Decompiled with CFR 0.152.
 */
package cicada.mq.receive;

import cicada.core.Guard;
import cicada.mq.receive.MqReceiveConnectionFactory;
import cicada.mq.receive.MqServerInfo;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class MqReceiveConnectionFactoryImpl
implements MqReceiveConnectionFactory {
    private final Map<MqServerInfo, ConnectionFactory> _factorys = new HashMap<MqServerInfo, ConnectionFactory>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection get(MqServerInfo mqServerInfo) throws Exception {
        Guard.ThrowIfArgumentIsNull((Object)mqServerInfo, (String)"mqServerInfo");
        if (!this._factorys.containsKey(mqServerInfo)) {
            MqReceiveConnectionFactoryImpl mqReceiveConnectionFactoryImpl = this;
            synchronized (mqReceiveConnectionFactoryImpl) {
                if (!this._factorys.containsKey(mqServerInfo)) {
                    ConnectionFactory connectionFactory = new ConnectionFactory();
                    connectionFactory.setHost(mqServerInfo.getServer());
                    if (mqServerInfo.getServerUserName() != null && !mqServerInfo.getServerUserName().isEmpty()) {
                        connectionFactory.setUsername(mqServerInfo.getServerUserName());
                    }
                    if (mqServerInfo.getServerPassword() != null && !mqServerInfo.getServerPassword().isEmpty()) {
                        connectionFactory.setPassword(mqServerInfo.getServerPassword());
                    }
                    if (mqServerInfo.getPort() != 0) {
                        connectionFactory.setPort(mqServerInfo.getPort());
                    }
                    connectionFactory.setRequestedHeartbeat(60);
                    connectionFactory.setAutomaticRecoveryEnabled(true);
                    this._factorys.put(mqServerInfo, connectionFactory);
                }
            }
        }
        ConnectionFactory factory = this._factorys.get(mqServerInfo);
        Connection connection = factory.newConnection();
        return connection;
    }
}

