/*
 * Decompiled with CFR 0.152.
 */
package cicada.mq.receive;

import cicada.core.Guard;
import cicada.mq.receive.MqReceiveConnectionFactory;
import cicada.mq.receive.MqReceiver;
import cicada.mq.receive.config.ReceiverInfo;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;
import org.springframework.context.annotation.Scope;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component(value="mqrecivedirect")
@Scope(value="prototype")
@Order(value=0)
public class MqReceiverImplDirect
implements MqReceiver {
    private static final Logger log = Logger.getLogger(MqReceiverImplDirect.class);
    private ReceiverInfo _info;
    private Connection _connection;
    private Channel _chanel;
    private Object _receiver;
    private Method _receiveMethod;
    private MqReceiveConnectionFactory _connectionFactory;

    public MqReceiverImplDirect(MqReceiveConnectionFactory connectionFactory) {
        this._connectionFactory = connectionFactory;
    }

    @Override
    public void init(ReceiverInfo info) throws Exception {
        Guard.ThrowIfArgumentIsNull((Object)info, (String)"info");
        this._info = info;
        Class<?> temp1 = this._info.getContractType();
        this._receiver = temp1.newInstance();
        this._receiveMethod = this._info.getContractType().getMethod("receive", this._info.getMessageType());
    }

    @Override
    public void run() throws Exception {
        this._connection = this._connectionFactory.get(this._info);
        this._chanel = this._connection.createChannel();
        this._chanel.queueDeclare(this._info.getChannelName(), true, false, true, null);
        this._chanel.basicQos(0, 1, false);
        DefaultConsumer consumer = new DefaultConsumer(this._chanel){

            public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                String message = new String(body, "UTF-8");
                System.out.println(" Consumer have received '" + message + "'");
            }
        };
        this._chanel.basicConsume(this._info.getChannelName(), true, (Consumer)consumer);
    }

    @Override
    public void close() {
        try {
            this._chanel.close();
            this._connection.close();
        }
        catch (IOException | TimeoutException e) {
            e.printStackTrace();
            log.error((Object)e);
        }
    }
}

