package cicada.mq.receive;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.concurrent.TimeoutException;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;

import cicada.core.BeanFactory;
import cicada.core.Guard;
import cicada.mq.receive.config.ReceiverInfo;


@Component("mqrecivedirect")
@Scope("prototype")
@Order(0)
public class MqReceiverImplDirect implements MqReceiver
{
	private static final Logger log = Logger.getLogger(MqReceiverImplDirect.class);

	private ReceiverInfo _info;

	private Connection _connection;

	private Channel _chanel;

	private Object _receiver;

	private Method _receiveMethod;

	private MqReceiveConnectionFactory _connectionFactory;
	
	public MqReceiverImplDirect(MqReceiveConnectionFactory connectionFactory)
	{
		_connectionFactory=connectionFactory;
	}

	@Override
	public void init(ReceiverInfo info) throws Exception
	{
		Guard.ThrowIfArgumentIsNull(info, "info");
		this._info = info;
		Class<?> temp1=this._info.getContractType();
		_receiver=temp1.newInstance();
		this._receiveMethod = this._info.getContractType().getMethod("receive", this._info.getMessageType());
	}

	@Override
	public void run() throws Exception
	{
		this._connection = this._connectionFactory.get(this._info);
		this._chanel = this._connection.createChannel();
		this._chanel.queueDeclare(this._info.getChannelName(), true, false, true, null);
		this._chanel.basicQos(0, 1, false);

		Consumer consumer = new DefaultConsumer(this._chanel)
		{
			@Override
			public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException
			{
				String message = new String(body, "UTF-8");
				System.out.println(" Consumer have received '" + message + "'");
			}
		};

		this._chanel.basicConsume(this._info.getChannelName(), true, consumer);
	}

	@Override
	public void close()
	{
		try
		{
			_chanel.close();
			_connection.close();
		}
		catch (IOException | TimeoutException e)
		{
			e.printStackTrace();
			log.error(e);
		}
		

	}
}
