package cicada.mq.receive;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.concurrent.TimeoutException;

import org.apache.log4j.Logger;
import org.springframework.context.annotation.Scope;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;

import cicada.core.BeanFactory;
import cicada.core.Guard;
import cicada.mq.receive.config.ReceiverInfo;

@Component("mqrecivebroadcast")
@Scope("prototype")
@Order(0)
public class MqReceiverImplBroadcast implements MqReceiver
{
	private static final Logger log = Logger.getLogger(MqReceiverImplBroadcast.class);

	private final MqReceiveConnectionFactory _connectionFactory;

	private ReceiverInfo _info;

	private Connection _connection;

	private Channel _chanel;

	private Object _receiver;

	private Method _receiveMethod;

	public MqReceiverImplBroadcast(MqReceiveConnectionFactory connectionFactory)
	{
		_connectionFactory = connectionFactory;
	}

	@Override
	public void init(ReceiverInfo info) throws Exception
	{
		Guard.ThrowIfArgumentIsNull(info, "info");
		this._info = info;
		this._receiver = _info.getContractType().newInstance();
		Class<?> contractType= this._info.getContractType();
		Class<?> paramType=this._info.getMessageType();
		this._receiveMethod =contractType.getMethod("receive", new Class<?>[] { paramType});
	}

	@Override
	public void run() throws Exception
	{
		this._connection = this._connectionFactory.get(this._info);
		this._chanel = this._connection.createChannel();
		this._chanel.exchangeDeclare(this._info.getChannelName(), "fanout", false);
		String text = this._chanel.queueDeclare("", false, true, true, null).getQueue();
		this._chanel.queueBind(text, this._info.getChannelName(), "");
		this._chanel.basicQos(0, 1, false);
		Consumer consumer = new DefaultConsumer(this._chanel)
		{
			@Override
			public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException
			{
				String message = new String(body, "UTF-8");
				System.out.println("Customer Received '" + message + "'");
			}
		};

		this._chanel.basicConsume("", true, consumer);
	}

	@Override
	public void close()
	{
		try
		{
			this._chanel.close();
			this._connection.close();
		}
		catch (IOException | TimeoutException e)
		{
			e.printStackTrace();
			log.error(e);
		}
	}
}
