package cicada.mq.receive.config;

import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;

import javax.sound.midi.Receiver;

import org.apache.log4j.Logger;

import com.fasterxml.jackson.annotation.JsonSubTypes.Type;

public class FillDataImplContract implements FillData
{

	private static final Logger log = Logger.getLogger(FillDataImplContract.class);

	@Override
	public boolean fill(String configName, String key, String data, ReceiverInfo info) throws Exception
	{
		if (data == null || data.isEmpty()) return false;

		info.setContractType(Class.forName(data));
		if (info.getContractType() == null)
		{
			return false;
		}
		if (info.getContractType().isInterface() || Modifier.isAbstract(info.getContractType().getModifiers()))
		{
			throw new Exception(String.format("您配置的契约类型%s必须是类并且不能是抽象的,请修改%s节点", data, configName));
		}

		Class<?> temp = getMessageType(info.getContractType());
		info.setMessageType(temp);
		if (info.getMessageType() == null)
		{
			throw new Exception(String.format("您配置的契约类型%s必须实现了Receiver接口，请修改%s节点", data, configName));
		}

		return true;
	}

	private Class<?> getMessageType(Class<?> contractType)
	{
		try
		{
			// Class<?> typeFromHandle = Receiver.class;
			ParameterizedType parameterizedType = (ParameterizedType) contractType.getGenericInterfaces()[0];
			Class<?> result = (Class<?>) parameterizedType.getActualTypeArguments()[0];
			return result;
		}
		catch (Exception e)
		{
		}
		return null;
	}
}
