package cicada.mq.receive;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;

import org.springframework.stereotype.Component;

import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;

import cicada.core.Guard;

@Component
public class MqReceiveConnectionFactoryImpl implements MqReceiveConnectionFactory
{
	private final Map<MqServerInfo, ConnectionFactory> _factorys = new HashMap<MqServerInfo, ConnectionFactory>();

	@Override
	public Connection get(MqServerInfo mqServerInfo) throws Exception
	{
		Guard.ThrowIfArgumentIsNull(mqServerInfo, "mqServerInfo");
		if (!this._factorys.containsKey(mqServerInfo))
		{
			synchronized (this)
			{
				if (!this._factorys.containsKey(mqServerInfo))
				{
					ConnectionFactory connectionFactory = new ConnectionFactory();
					connectionFactory.setHost(mqServerInfo.getServer());
					if (mqServerInfo.getServerUserName() != null && !mqServerInfo.getServerUserName().isEmpty())
					{
						connectionFactory.setUsername(mqServerInfo.getServerUserName());
					}
					if (mqServerInfo.getServerPassword() != null && !mqServerInfo.getServerPassword().isEmpty())
					{
						connectionFactory.setPassword(mqServerInfo.getServerPassword());
					}
					if (mqServerInfo.getPort() != 0)
					{
						connectionFactory.setPort(mqServerInfo.getPort());
					}
					connectionFactory.setRequestedHeartbeat(60);
					connectionFactory.setAutomaticRecoveryEnabled(true);
					this._factorys.put(mqServerInfo, connectionFactory);
				}
			}
		}
		ConnectionFactory factory = this._factorys.get(mqServerInfo);
		Connection connection = factory.newConnection();
		return connection;
	}
}
