/*
 * Decompiled with CFR 0.152.
 */
package cicada.mq.receive.config;

import cicada.core.PropertyResolverCustom;
import cicada.mq.receive.config.FillData;
import cicada.mq.receive.config.FillDataImplChannelName;
import cicada.mq.receive.config.FillDataImplContract;
import cicada.mq.receive.config.FillDataImplPort;
import cicada.mq.receive.config.FillDataImplServer;
import cicada.mq.receive.config.FillDataImplServerPassword;
import cicada.mq.receive.config.FillDataImplServerUserName;
import cicada.mq.receive.config.FillDataImplType;
import cicada.mq.receive.config.ReceiverConfig;
import cicada.mq.receive.config.ReceiverInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Component;

@Component
public class ReceiverConfigImpl
implements ReceiverConfig {
    private static final Map<String, FillData> fillDataStrategies;
    private final List<ReceiverInfo> _receivers = new ArrayList<ReceiverInfo>();
    private final Map<String, String> _configurationDataRespository = PropertyResolverCustom.getConfigProperties((String)"conf/cicada.properties");
    private boolean _loaded;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ReceiverInfo> getReceivers() throws Exception {
        if (!this._loaded) {
            ReceiverConfigImpl receiverConfigImpl = this;
            synchronized (receiverConfigImpl) {
                if (!this._loaded) {
                    List<ReceiverInfo> list = this.loadByConfig();
                    for (ReceiverInfo current : list) {
                        this._receivers.add(current);
                    }
                }
                this._loaded = true;
            }
        }
        return this._receivers;
    }

    private List<ReceiverInfo> loadByConfig() throws Exception {
        HashMap<String, ReceiverInfo> receiverInfos = new HashMap<String, ReceiverInfo>();
        for (Map.Entry<String, String> entry : this._configurationDataRespository.entrySet()) {
            String text = entry.getKey();
            String regEx = "^Cicada.Mq.Receivers.(\\w+).([\\w.]+)$";
            Pattern pattern = Pattern.compile(regEx, 2);
            Matcher matcher = pattern.matcher(text);
            if (!matcher.matches() || matcher.groupCount() != 2) continue;
            ReceiverInfo receiverInfo = null;
            String group1 = matcher.group(1);
            if (receiverInfos.containsKey(group1)) {
                receiverInfo = (ReceiverInfo)receiverInfos.get(group1);
            } else {
                receiverInfo = new ReceiverInfo();
                receiverInfos.put(group1, receiverInfo);
            }
            String key = matcher.group(2).toLowerCase();
            if (!fillDataStrategies.containsKey(key)) {
                throw new Exception(String.format("\u672a\u77e5\u7684\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u8282\u70b9%s\u662f\u5426\u914d\u7f6e\u6b63\u786e", text));
            }
            FillData temp = fillDataStrategies.get(key);
            boolean result = temp.fill(text, key, entry.getValue(), receiverInfo);
            if (result) continue;
            throw new Exception(String.format("\u9519\u8bef\u7684\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u8282\u70b9%s\u662f\u5426\u914d\u7f6e\u6b63\u786e", text));
        }
        ArrayList<ReceiverInfo> result = new ArrayList<ReceiverInfo>(receiverInfos.values());
        return result;
    }

    static {
        HashMap<String, FillData> map = new HashMap<String, FillData>();
        map.put("contract", new FillDataImplContract());
        map.put("channel", new FillDataImplChannelName());
        map.put("type", new FillDataImplType());
        map.put("server", new FillDataImplServer());
        map.put("server.port", new FillDataImplPort());
        map.put("server.username", new FillDataImplServerUserName());
        map.put("server.password", new FillDataImplServerPassword());
        fillDataStrategies = map;
    }
}

