/*
 * Decompiled with CFR 0.152.
 */
package cicada.filesystem;

import cicada.core.PropertyResolverCustom;
import cicada.filesystem.FileSystem;
import cicada.filesystem.distributed.FileSystemImplDistributed;
import cicada.filesystem.local.FileSystemImplLocal;
import java.io.IOException;
import java.util.Map;
import org.csource.common.MyException;
import org.springframework.stereotype.Component;

@Component
public class FileSystemImpl
implements FileSystem {
    private final String typeConfigName = "Cicada.FileSystem.Type";
    private FileSystem _fileSystem = null;

    public FileSystemImpl() throws Exception {
        Map configurationDataRespository = PropertyResolverCustom.getConfigProperties((String)"conf/cicada.properties");
        String text = (String)configurationDataRespository.get("Cicada.FileSystem.Type");
        if (text == null || text.isEmpty()) {
            text = "local";
        }
        if ((text = text.toLowerCase()).equals("local")) {
            this._fileSystem = new FileSystemImplLocal(configurationDataRespository);
            return;
        }
        if (text.equals("distributed")) {
            this._fileSystem = new FileSystemImplDistributed(configurationDataRespository);
            return;
        }
        throw new Exception(String.format("\u60a8\u914d\u7f6e\u7684\u6587\u4ef6\u7cfb\u7edf\u7c7b\u578b\u65e0\u6548\uff0c\u8bf7\u914d\u7f6e%s\u8282\u70b9", "Cicada.FileSystem.Type"));
    }

    @Override
    public String upload(byte[] data, String fileExt) throws Exception {
        return this._fileSystem.upload(data, fileExt, 0);
    }

    @Override
    public String upload1(byte[] data, String fileName) throws IOException, MyException, Exception {
        return this._fileSystem.upload1(data, fileName, 0);
    }

    @Override
    public String upload(byte[] data, String fileExt, int resultPathType) throws Exception {
        return this._fileSystem.upload(data, fileExt, resultPathType);
    }

    @Override
    public String upload1(byte[] data, String fileName, int resultPathType) throws IOException, MyException, Exception {
        return this._fileSystem.upload1(data, fileName, resultPathType);
    }

    @Override
    public byte[] download(String fileName) throws IOException, MyException, Exception {
        return this._fileSystem.download(fileName);
    }

    @Override
    public boolean remove(String fileName) throws Exception {
        return this._fileSystem.remove(fileName);
    }
}

