package cicada.filesystem;

import java.io.IOException;

import org.csource.common.MyException;

public interface FileSystem
{

	/**
	 * @param data
	 * @param fileExt
	 * 文件扩展名 文件名称动态生成
	 * @return
	 * @throws IOException
	 * @throws MyException
	 * @throws Exception
	 */
	String upload(byte[] data, String fileExt) throws IOException, MyException, Exception;

	/**
	 * @param data
	 * @param fileName
	 * 文件名称 上传以后的文件名称不变
	 * @return
	 * @throws IOException
	 * @throws MyException
	 * @throws Exception
	 */
	String upload1(byte[] data, String fileName) throws IOException, MyException, Exception;

	/**
	 * @param data
	 * @param fileExt
	 * @param resultPathType
	 * 0 返回相对路径1:返回绝对路径
	 * @return
	 * @throws IOException
	 * @throws MyException
	 * @throws Exception
	 */
	String upload(byte[] data, String fileExt, int resultPathType) throws IOException, MyException, Exception;

	/**
	 * @param data
	 * @param fileName
	 * 文件名称 上传以后的文件名称不变
	 * @param resultPathType
	 * 0 返回相对路径1:返回绝对路径
	 * @return
	 * @throws IOException
	 * @throws MyException
	 * @throws Exception
	 */
	String upload1(byte[] data, String fileName, int resultPathType) throws IOException, MyException, Exception;

	byte[] download(String fileName) throws IOException, MyException, Exception;

	boolean remove(String fileName) throws Exception;

}
