/*
 * Decompiled with CFR 0.152.
 */
package cicada.filesystem.local;

import cicada.core.Guard;
import cicada.filesystem.FileSystem;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.csource.common.MyException;

public class FileSystemImplLocal
implements FileSystem {
    private static final Logger log = Logger.getLogger(FileSystemImplLocal.class);
    private final String rootConfigName = "Cicada.FileSystem.Local.Root";
    private String _root;

    public FileSystemImplLocal(Map<String, String> configurationDataRespository) throws Exception {
        this._root = configurationDataRespository.get("Cicada.FileSystem.Local.Root");
        if (this._root == null || this._root.isEmpty()) {
            throw new Exception(String.format("\u8bf7\u4e3a\u672c\u5730\u6587\u4ef6\u7cfb\u7edf\u8bbe\u7f6e\u6839\u76ee\u5f55\uff0c\u8bf7\u914d\u7f6e%s\u8282\u70b9", "Cicada.FileSystem.Local.Root"));
        }
        String projectRoot = System.getProperty("user.dir");
        StringBuffer sb = new StringBuffer();
        this._root = sb.append(projectRoot).append(File.separator).append(this._root).toString();
    }

    @Override
    public String upload(byte[] data, String fileExt) throws Exception {
        String result = this.upload(data, fileExt, 0);
        return result;
    }

    @Override
    public String upload1(byte[] data, String fileName) throws IOException, MyException, Exception {
        String result = this.upload(data, fileName, 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String upload(byte[] data, String fileExt, int resultPathType) throws Exception {
        Guard.ThrowIfArgumentIsNull((Object)data, (String)"data");
        Guard.ThrowIfArgumentIsNullOrEmpty((String)fileExt, (String)"fileExt");
        SimpleDateFormat sdf = new SimpleDateFormat(String.format("yyyy%sMM%sdd", File.separator, File.separator));
        String path = sdf.format(new Date());
        path = this._root + File.separator + path;
        File filePath = new File(path);
        if (!filePath.exists() && !filePath.mkdirs()) {
            return null;
        }
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String fileName = uuid + "." + fileExt;
        fileName = path + File.separator + fileName;
        File temp = new File(fileName);
        boolean result = temp.createNewFile();
        if (!result) {
            return null;
        }
        try (FilterOutputStream stream = null;){
            stream = new BufferedOutputStream(new FileOutputStream(temp));
            stream.write(data);
        }
        if (resultPathType == 0) {
            return fileName.replace(this._root, "");
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String upload1(byte[] data, String fileName, int resultPathType) throws IOException, MyException, Exception {
        Guard.ThrowIfArgumentIsNull((Object)data, (String)"data");
        Guard.ThrowIfArgumentIsNullOrEmpty((String)fileName, (String)"fileName");
        SimpleDateFormat sdf = new SimpleDateFormat(String.format("yyyy%sMM%sdd", File.separator, File.separator));
        String path = sdf.format(new Date());
        path = this._root + File.separator + path;
        File filePath = new File(path);
        if (!filePath.exists() && !filePath.mkdirs()) {
            return null;
        }
        fileName = path + File.separator + fileName;
        File temp = new File(fileName);
        boolean result = temp.createNewFile();
        if (!result) {
            return null;
        }
        try (FilterOutputStream stream = null;){
            stream = new BufferedOutputStream(new FileOutputStream(temp));
            stream.write(data);
        }
        if (resultPathType == 0) {
            return fileName.replace(this._root, "");
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] download(String fileName) throws Exception {
        Guard.ThrowIfArgumentIsNull((Object)fileName, (String)"fileName");
        String physicsPath = this._root + File.separator + fileName;
        File file = new File(physicsPath);
        if (file.exists()) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream((int)file.length());
            BufferedInputStream in = null;
            try {
                in = new BufferedInputStream(new FileInputStream(file));
                int buf_size = 1024;
                byte[] buffer = new byte[buf_size];
                int len = 0;
                while (-1 != (len = in.read(buffer, 0, buf_size))) {
                    bos.write(buffer, 0, len);
                }
                byte[] byArray = bos.toByteArray();
                return byArray;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
        }
        return null;
    }

    @Override
    public boolean remove(String fileName) throws Exception {
        Guard.ThrowIfArgumentIsNull((Object)fileName, (String)"fileName");
        String physicsPath = this._root + File.separator + fileName;
        File file = new File(physicsPath);
        if (!file.exists()) {
            return true;
        }
        return file.delete();
    }
}

