/*
 * Decompiled with CFR 0.152.
 */
package cicada.filesystem.distributed;

import cicada.core.Guard;
import cicada.filesystem.FileSystem;
import java.util.Map;
import org.apache.log4j.Logger;
import org.csource.fastdfs.ClientGlobal;
import org.csource.fastdfs.StorageClient;
import org.csource.fastdfs.StorageServer;
import org.csource.fastdfs.TrackerClient;
import org.csource.fastdfs.TrackerServer;

public class FileSystemImplDistributed
implements FileSystem {
    private static final Logger log = Logger.getLogger(FileSystemImplDistributed.class);
    private final String serverConfigName = "Cicada.FileSystem.Distributed.Server";
    private final String groupNameConfigName = "Cicada.FileSystem.Distributed.GroupName";
    private final String pathUrlPrefix = "Cicada.FileSystem.UrlPrefix";
    private Map<String, String> _configurationDataRespository;
    private String _groupName;

    public FileSystemImplDistributed(Map<String, String> configurationDataRespository) throws Exception {
        this._configurationDataRespository = configurationDataRespository;
        this.initFastDfs();
        this._groupName = configurationDataRespository.get("Cicada.FileSystem.Distributed.GroupName");
        if (this._groupName == null || this._groupName.isEmpty()) {
            throw new Exception(String.format("\u8bf7\u4e3a\u5206\u5e03\u5f0f\u6587\u4ef6\u7cfb\u7edf\u8bbe\u7f6e\u7ec4\u540d\u79f0\uff0c\u8bf7\u914d\u7f6e%s\u8282\u70b9", "Cicada.FileSystem.Distributed.GroupName"));
        }
    }

    @Override
    public String upload(byte[] data, String fileExt) throws Exception {
        String result = this.upload(data, fileExt, 0);
        return result;
    }

    @Override
    public String upload(byte[] data, String fileExt, int resultPathType) throws Exception {
        Guard.ThrowIfArgumentIsNull((Object)data, (String)"data");
        Guard.ThrowIfArgumentIsNull((Object)fileExt, (String)"fileExt");
        TrackerClient tracker = new TrackerClient();
        TrackerServer trackerServer = tracker.getConnection();
        StorageServer storageServer = null;
        StorageClient client = new StorageClient(trackerServer, storageServer);
        String[] fileInfo = client.upload_file(this._groupName, data, fileExt, null);
        if (fileInfo == null) {
            return null;
        }
        String result = String.format("%s/%s", fileInfo[0], fileInfo[1]);
        if (resultPathType != 0) {
            String temp = this._configurationDataRespository.get("Cicada.FileSystem.UrlPrefix");
            if (temp == null || temp.isEmpty()) {
                log.error((Object)String.format("\u5c06\u6587\u4ef6\u8def\u5f84\u8f6c\u6362\u4e3a\u7edd\u5bf9\u8def\u5f84\u65f6\u51fa\u73b0\u9519\u8bef\uff0c\u9519\u8bef\u539f\u56e0\u662f\u6ca1\u6709\u914d\u7f6eUrl\u524d\u7f00\uff0c\u8bf7\u901a\u8fc7\u914d\u7f6e\u6587\u4ef6\u914d\u7f6e%s\u8282\u70b9", "Cicada.FileSystem.UrlPrefix"));
            } else {
                result = String.format("%s/%s", temp, result);
            }
        }
        return result;
    }

    @Override
    public byte[] download(String fileName) throws Exception {
        Guard.ThrowIfArgumentIsNullOrEmpty((String)fileName, (String)"fileName");
        FilePath filePath = new FilePath(fileName);
        TrackerClient tracker = new TrackerClient();
        TrackerServer trackerServer = tracker.getConnection();
        StorageServer storageServer = null;
        StorageClient storageClient = new StorageClient(trackerServer, storageServer);
        String groupName = filePath.getGroupName();
        String storageFileName = filePath.getStorageFileName();
        return storageClient.download_file(groupName, storageFileName);
    }

    @Override
    public boolean remove(String fileName) throws Exception {
        Guard.ThrowIfArgumentIsNullOrEmpty((String)fileName, (String)"fileName");
        FilePath filePath = new FilePath(fileName);
        TrackerClient tracker = new TrackerClient();
        TrackerServer trackerServer = tracker.getConnection();
        StorageServer storageServer = null;
        String groupName = filePath.getGroupName();
        String storageFileName = filePath.getStorageFileName();
        StorageClient storageClient = new StorageClient(trackerServer, storageServer);
        int result = storageClient.delete_file(groupName, storageFileName);
        if (result == 0) {
            return true;
        }
        log.info((Object)String.format("\u5220\u9664\u5931\u8d25:\u72b6\u6001\u7801\u4e3a%s", result));
        return false;
    }

    private void initFastDfs() throws Exception {
        String text = this._configurationDataRespository.get("Cicada.FileSystem.Distributed.Server");
        if (text == null || text.isEmpty()) {
            throw new Exception(String.format("\u8bf7\u4e3a\u5206\u5e03\u5f0f\u6587\u4ef6\u7cfb\u7edf\u8bbe\u7f6e\u670d\u52a1\u5668\u8def\u5f84\uff0c\u8bf7\u914d\u7f6e%s\u8282\u70b9", "Cicada.FileSystem.Distributed.Server"));
        }
        try {
            ClientGlobal.initByTrackers((String)text);
        }
        catch (Exception e) {
            throw new Exception(String.format("\u60a8\u914d\u7f6e\u7684\u5206\u5e03\u5f0f\u6587\u4ef6\u7cfb\u7edf\u670d\u52a1\u5668\u8def\u5f84\u65e0\u6548\uff0c\u8bf7\u914d\u7f6e%s\u8282\u70b9", "Cicada.FileSystem.Distributed.Server"));
        }
    }

    private class FilePath {
        private String groupName;
        private String storageFileName;

        public String getGroupName() {
            return this.groupName;
        }

        public void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public String getStorageFileName() {
            return this.storageFileName;
        }

        public void setStorageFileName(String storageFileName) {
            this.storageFileName = storageFileName;
        }

        public FilePath(String fileName) {
            int num = fileName.indexOf(47);
            this.groupName = fileName.substring(0, num);
            this.storageFileName = fileName.substring(num + 1);
        }

        public String toString() {
            return this.groupName + '/' + this.storageFileName;
        }
    }
}

