/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package cicada.chardet;

import java.lang.* ;

public class GB2312Statistics extends nsEUCStatistics {


     static float[] mFirstByteFreq ;
     static float   mFirstByteStdDev;
     static float   mFirstByteMean;
     static float   mFirstByteWeight;
     static float[] mSecondByteFreq;
     static float   mSecondByteStdDev;
     static float   mSecondByteMean;
     static float   mSecondByteWeight;

     public float[] mFirstByteFreq() { return mFirstByteFreq; }  
     public float   mFirstByteStdDev()  { return mFirstByteStdDev; }  
     public float   mFirstByteMean()  { return mFirstByteMean; }  
     public float   mFirstByteWeight()  { return mFirstByteWeight; }  
     public float[] mSecondByteFreq()  { return mSecondByteFreq; }  
     public float   mSecondByteStdDev()  { return mSecondByteStdDev; }  
     public float   mSecondByteMean()  { return mSecondByteMean; }  
     public float   mSecondByteWeight()  { return mSecondByteWeight; }  

	public GB2312Statistics() {

	    mFirstByteFreq = new float[] {
               0.011628f, // FreqH[a1]
               0.000000f, // FreqH[a2]
               0.000000f, // FreqH[a3]
               0.000000f, // FreqH[a4]
               0.000000f, // FreqH[a5]
               0.000000f, // FreqH[a6]
               0.000000f, // FreqH[a7]
               0.000000f, // FreqH[a8]
               0.000000f, // FreqH[a9]
               0.000000f, // FreqH[aa]
               0.000000f, // FreqH[ab]
               0.000000f, // FreqH[ac]
               0.000000f, // FreqH[ad]
               0.000000f, // FreqH[ae]
               0.000000f, // FreqH[af]
               0.011628f, // FreqH[b0]
               0.012403f, // FreqH[b1]
               0.009302f, // FreqH[b2]
               0.003876f, // FreqH[b3]
               0.017829f, // FreqH[b4]
               0.037209f, // FreqH[b5]
               0.008527f, // FreqH[b6]
               0.010078f, // FreqH[b7]
               0.019380f, // FreqH[b8]
               0.054264f, // FreqH[b9]
               0.010078f, // FreqH[ba]
               0.041085f, // FreqH[bb]
               0.020930f, // FreqH[bc]
               0.018605f, // FreqH[bd]
               0.010078f, // FreqH[be]
               0.013178f, // FreqH[bf]
               0.016279f, // FreqH[c0]
               0.006202f, // FreqH[c1]
               0.009302f, // FreqH[c2]
               0.017054f, // FreqH[c3]
               0.011628f, // FreqH[c4]
               0.008527f, // FreqH[c5]
               0.004651f, // FreqH[c6]
               0.006202f, // FreqH[c7]
               0.017829f, // FreqH[c8]
               0.024806f, // FreqH[c9]
               0.020155f, // FreqH[ca]
               0.013953f, // FreqH[cb]
               0.032558f, // FreqH[cc]
               0.035659f, // FreqH[cd]
               0.068217f, // FreqH[ce]
               0.010853f, // FreqH[cf]
               0.036434f, // FreqH[d0]
               0.117054f, // FreqH[d1]
               0.027907f, // FreqH[d2]
               0.100775f, // FreqH[d3]
               0.010078f, // FreqH[d4]
               0.017829f, // FreqH[d5]
               0.062016f, // FreqH[d6]
               0.012403f, // FreqH[d7]
               0.000000f, // FreqH[d8]
               0.000000f, // FreqH[d9]
               0.000000f, // FreqH[da]
               0.000000f, // FreqH[db]
               0.000000f, // FreqH[dc]
               0.000000f, // FreqH[dd]
               0.000000f, // FreqH[de]
               0.000000f, // FreqH[df]
               0.000000f, // FreqH[e0]
               0.000000f, // FreqH[e1]
               0.000000f, // FreqH[e2]
               0.000000f, // FreqH[e3]
               0.000000f, // FreqH[e4]
               0.000000f, // FreqH[e5]
               0.000000f, // FreqH[e6]
               0.000000f, // FreqH[e7]
               0.000000f, // FreqH[e8]
               0.000000f, // FreqH[e9]
               0.001550f, // FreqH[ea]
               0.000000f, // FreqH[eb]
               0.000000f, // FreqH[ec]
               0.000000f, // FreqH[ed]
               0.000000f, // FreqH[ee]
               0.000000f, // FreqH[ef]
               0.000000f, // FreqH[f0]
               0.000000f, // FreqH[f1]
               0.000000f, // FreqH[f2]
               0.000000f, // FreqH[f3]
               0.000000f, // FreqH[f4]
               0.000000f, // FreqH[f5]
               0.000000f, // FreqH[f6]
               0.000000f, // FreqH[f7]
               0.000000f, // FreqH[f8]
               0.000000f, // FreqH[f9]
               0.000000f, // FreqH[fa]
               0.000000f, // FreqH[fb]
               0.000000f, // FreqH[fc]
               0.000000f, // FreqH[fd]
               0.000000f  // FreqH[fe]

	};

	mFirstByteStdDev = 0.020081f; // Lead Byte StdDev
	mFirstByteMean = 0.010638f; // Lead Byte Mean
	mFirstByteWeight = 0.586533f; // Lead Byte Weight

	mSecondByteFreq = new float[] {
                    0.006202f, // FreqL[a1]
                    0.031008f, // FreqL[a2]
                    0.005426f, // FreqL[a3]
                    0.003101f, // FreqL[a4]
                    0.001550f, // FreqL[a5]
                    0.003101f, // FreqL[a6]
                    0.082171f, // FreqL[a7]
                    0.014729f, // FreqL[a8]
                    0.006977f, // FreqL[a9]
                    0.001550f, // FreqL[aa]
                    0.013953f, // FreqL[ab]
                    0.000000f, // FreqL[ac]
                    0.013953f, // FreqL[ad]
                    0.010078f, // FreqL[ae]
                    0.008527f, // FreqL[af]
                    0.006977f, // FreqL[b0]
                    0.004651f, // FreqL[b1]
                    0.003101f, // FreqL[b2]
                    0.003101f, // FreqL[b3]
                    0.003101f, // FreqL[b4]
                    0.008527f, // FreqL[b5]
                    0.003101f, // FreqL[b6]
                    0.005426f, // FreqL[b7]
                    0.005426f, // FreqL[b8]
                    0.005426f, // FreqL[b9]
                    0.003101f, // FreqL[ba]
                    0.001550f, // FreqL[bb]
                    0.006202f, // FreqL[bc]
                    0.014729f, // FreqL[bd]
                    0.010853f, // FreqL[be]
                    0.000000f, // FreqL[bf]
                    0.011628f, // FreqL[c0]
                    0.000000f, // FreqL[c1]
                    0.031783f, // FreqL[c2]
                    0.013953f, // FreqL[c3]
                    0.030233f, // FreqL[c4]
                    0.039535f, // FreqL[c5]
                    0.008527f, // FreqL[c6]
                    0.015504f, // FreqL[c7]
                    0.000000f, // FreqL[c8]
                    0.003101f, // FreqL[c9]
                    0.008527f, // FreqL[ca]
                    0.016279f, // FreqL[cb]
                    0.005426f, // FreqL[cc]
                    0.001550f, // FreqL[cd]
                    0.013953f, // FreqL[ce]
                    0.013953f, // FreqL[cf]
                    0.044961f, // FreqL[d0]
                    0.003101f, // FreqL[d1]
                    0.004651f, // FreqL[d2]
                    0.006977f, // FreqL[d3]
                    0.001550f, // FreqL[d4]
                    0.005426f, // FreqL[d5]
                    0.012403f, // FreqL[d6]
                    0.001550f, // FreqL[d7]
                    0.015504f, // FreqL[d8]
                    0.000000f, // FreqL[d9]
                    0.006202f, // FreqL[da]
                    0.001550f, // FreqL[db]
                    0.000000f, // FreqL[dc]
                    0.007752f, // FreqL[dd]
                    0.006977f, // FreqL[de]
                    0.001550f, // FreqL[df]
                    0.009302f, // FreqL[e0]
                    0.011628f, // FreqL[e1]
                    0.004651f, // FreqL[e2]
                    0.010853f, // FreqL[e3]
                    0.012403f, // FreqL[e4]
                    0.017829f, // FreqL[e5]
                    0.005426f, // FreqL[e6]
                    0.024806f, // FreqL[e7]
                    0.000000f, // FreqL[e8]
                    0.006202f, // FreqL[e9]
                    0.000000f, // FreqL[ea]
                    0.082171f, // FreqL[eb]
                    0.015504f, // FreqL[ec]
                    0.004651f, // FreqL[ed]
                    0.000000f, // FreqL[ee]
                    0.006977f, // FreqL[ef]
                    0.004651f, // FreqL[f0]
                    0.000000f, // FreqL[f1]
                    0.008527f, // FreqL[f2]
                    0.012403f, // FreqL[f3]
                    0.004651f, // FreqL[f4]
                    0.003876f, // FreqL[f5]
                    0.003101f, // FreqL[f6]
                    0.022481f, // FreqL[f7]
                    0.024031f, // FreqL[f8]
                    0.001550f, // FreqL[f9]
                    0.047287f, // FreqL[fa]
                    0.009302f, // FreqL[fb]
                    0.001550f, // FreqL[fc]
                    0.005426f, // FreqL[fd]
                    0.017054f  // FreqL[fe]

	};

	mSecondByteStdDev = 0.014156f; // Trail Byte StdDev
	mSecondByteMean = 0.010638f; // Trail Byte Mean
	mSecondByteWeight = 0.413467f; // Trial Byte Weight
	}

}
