/*
 * Decompiled with CFR 0.152.
 */
package cicada.thrift.client;

import cicada.thrift.client.EndpointConfig;
import cicada.thrift.client.EndpointInfo;
import cicada.thrift.client.RpcClient;
import cicada.thrift.client.ThriftClientInterceptor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class ThriftClientBoot
implements CommandLineRunner {
    private Logger log = LoggerFactory.getLogger(ThriftClientBoot.class);
    @Autowired
    private EndpointConfig _endpointConfig;
    @Autowired
    ApplicationContext context;

    public void run(String ... args) {
        try {
            List<EndpointInfo> list = this._endpointConfig.load();
            if (list != null && list.size() > 0) {
                ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)this.context;
                DefaultListableBeanFactory facotry = (DefaultListableBeanFactory)configurableApplicationContext.getBeanFactory();
                for (EndpointInfo endpointInfo : list) {
                    RpcClient client = new RpcClient(endpointInfo);
                    ThriftClientInterceptor thriftClientInterceptor = new ThriftClientInterceptor(endpointInfo, client);
                    Class<?> type = endpointInfo.getContractType();
                    Class[] interfaces = new Class[]{type};
                    Object proxy = Proxy.newProxyInstance(type.getClassLoader(), interfaces, (InvocationHandler)thriftClientInterceptor);
                    String beanName = type.getName().toLowerCase().trim();
                    facotry.registerSingleton(beanName, proxy);
                    if (!this.log.isInfoEnabled()) continue;
                    this.log.info("rpc \u5ba2\u6237\u7aef\u6ce8\u518c\u6210\u529f,name:{},class:{},loader:{}", new Object[]{beanName, proxy.getClass().getName(), proxy.getClass().getClassLoader().toString()});
                }
            }
        }
        catch (Exception e) {
            this.log.error("\u6ce8\u5165cicada_thrift\u5ba2\u6237\u7aef\u51fa\u9519:{} \u8be6\u7ec6\u4fe1\u606f:{}", (Object)e.getMessage(), (Object)e.getStackTrace());
        }
    }
}

