/*
 * Decompiled with CFR 0.152.
 */
package cicada.thrift.client;

import cicada.core.PropertyResolverCustom;
import cicada.core.config.ConfigManager;
import cicada.thrift.client.EndpointInfo;
import cicada.thrift.client.endpoints.FillData;
import cicada.thrift.client.endpoints.FillDataImplContract;
import cicada.thrift.client.endpoints.FillDataImplServer;
import cicada.thrift.client.endpoints.FillDataImplServerCentreName;
import cicada.thrift.client.endpoints.FillDataImplServerCentreRespository;
import cicada.thrift.client.endpoints.FillDataImplServiceFinderType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class EndpointConfig {
    private static final Map<String, FillData> fillDataStrategies;

    public List<EndpointInfo> load() throws Exception {
        String cicadaPath = ConfigManager.getCicadaConfigPath();
        Map config = PropertyResolverCustom.getConfigProperties((String)cicadaPath);
        HashMap<String, EndpointInfo> endpoints = new HashMap<String, EndpointInfo>();
        for (Map.Entry entry : config.entrySet()) {
            String value;
            String text = (String)entry.getKey();
            String regEx = "^Cicada.Rpc.Client.Endpoints.(\\w+).([\\w.]+)$";
            Pattern pattern = Pattern.compile(regEx, 2);
            Matcher matcher = pattern.matcher(text);
            if (!matcher.matches() || matcher.groupCount() != 2) continue;
            EndpointInfo endpointInfo = null;
            String group1 = matcher.group(1);
            if (endpoints.containsKey(group1)) {
                endpointInfo = (EndpointInfo)endpoints.get(group1);
            } else {
                endpointInfo = new EndpointInfo();
                endpoints.put(group1, endpointInfo);
            }
            String key = matcher.group(2).toLowerCase();
            if (!fillDataStrategies.containsKey(key)) {
                throw new Exception(String.format("\u672a\u77e5\u7684\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u8282\u70b9%s\u662f\u5426\u914d\u7f6e\u6b63\u786e", text));
            }
            FillData temp = fillDataStrategies.get(key);
            boolean result = temp.fill(text, key, value = (String)entry.getValue(), endpointInfo);
            if (result) continue;
            throw new Exception(String.format("\u9519\u8bef\u7684\u914d\u7f6e\uff0c\u8bf7\u68c0\u67e5\u8282\u70b9%s\u662f\u5426\u914d\u7f6e\u6b63\u786e", text));
        }
        ArrayList<EndpointInfo> result = new ArrayList<EndpointInfo>(endpoints.values());
        return result;
    }

    static {
        HashMap<String, FillData> map = new HashMap<String, FillData>();
        map.put("contract", new FillDataImplContract());
        map.put("server", new FillDataImplServer());
        map.put("servicefindertype", new FillDataImplServiceFinderType());
        map.put("servicecentre.respositoryserver", new FillDataImplServerCentreRespository());
        map.put("servicecentre.name", new FillDataImplServerCentreName());
        fillDataStrategies = map;
    }
}

