/**
 * 
 */
package cicada.thrift.client.servicefinders;

import java.util.HashMap;
import java.util.Map;

import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import cicada.core.Guard;
import cicada.thrift.client.EndpointInfo;
import cicada.thrift.client.model.Address;

/**
 * @author user
 */
@Component("direct")
@Scope("prototype")
public class ServiceFindersImplDirect implements ServiceFinder
{

	private EndpointInfo _endpointInfo;

	private Address _serviceAddress;

	@Override
	public void init(EndpointInfo endpointInfo) throws Exception
	{
		Guard.ThrowIfArgumentIsNull(endpointInfo, "endpointInfo");
		this._endpointInfo = endpointInfo;
		_serviceAddress=new Address();
		_serviceAddress.setIp(_endpointInfo.getServer());
		_serviceAddress.setPort(_endpointInfo.getPort());
	}

	@Override
	public Address getServiceLocation()
	{
		return _serviceAddress;
	}

	@Override
	public void reportInvalidServiceLocation(Map<String, Integer> serviceLocation)
	{
	}
}
