/**
 * 
 */
package cicada.thrift.client.endpoints;

import cicada.thrift.client.EndpointInfo;

/**
 * @author user
 */
public class FillDataImplServer implements FillData
{

	/*
	 * (non-Javadoc)
	 * @see cicada.thrift.client.endpoints.FillData#fill(java.lang.String,
	 * java.lang.String, java.lang.String, cicada.thrift.client.EndpointInfo)
	 */
	@Override
	public boolean fill(String configName, String key, String data, EndpointInfo info) throws Exception
	{
		if (data == null || data.isEmpty()) return true;
		String[] array = data.split(":");
		if (array == null || array.length != 2)
		{
			return false;
		}
		info.setServer(array[0].trim());
		try
		{
			int port = Integer.parseInt(array[1]);
			info.setPort(port);
		}
		catch (Exception e)
		{
			throw new Exception(String.format("配置的值%s不是有效的端口号，请检查%s配置项", data,configName));
		}
		return true;
	}

}
