package cicada.thrift.client;

import java.lang.reflect.Proxy;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class ThriftClientBoot implements CommandLineRunner
{
	private Logger log = LoggerFactory.getLogger(ThriftClientBoot.class);

	@Autowired
	private EndpointConfig _endpointConfig;

	@Autowired
	ApplicationContext context;

	@Override
	public void run(String... args)
	{
		try
		{
			List<EndpointInfo> list = this._endpointConfig.load();
			if (list != null && list.size() > 0)
			{
				ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext) context;
				DefaultListableBeanFactory facotry = (DefaultListableBeanFactory) configurableApplicationContext.getBeanFactory();
				for (EndpointInfo endpointInfo : list)
				{
					RpcClient client = new RpcClient(endpointInfo);
					ThriftClientInterceptor thriftClientInterceptor = new ThriftClientInterceptor(endpointInfo, client);
					Class<?> type = endpointInfo.getContractType();
					Class<?>[] interfaces = new Class<?>[] { type };
					Object proxy = Proxy.newProxyInstance(type.getClassLoader(), interfaces, thriftClientInterceptor);
					String beanName = type.getName().toLowerCase().trim();
					facotry.registerSingleton(beanName, proxy);
					if (log.isInfoEnabled())
					{
						log.info("rpc 客户端注册成功,name:{},class:{},loader:{}", beanName, proxy.getClass().getName(), proxy.getClass().getClassLoader().toString());
					}
				}
			}
		}
		catch (Exception e)
		{
			log.error("注入cicada_thrift客户端出错:{} 详细信息:{}", e.getMessage(),e.getStackTrace());
		}
	}
}
