/**
 * 
 */
package cicada.thrift.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import cicada.core.PropertyResolverCustom;
import cicada.core.config.ConfigManager;
import cicada.thrift.client.endpoints.FillData;
import cicada.thrift.client.endpoints.FillDataImplContract;
import cicada.thrift.client.endpoints.FillDataImplServer;
import cicada.thrift.client.endpoints.FillDataImplServerCentreName;
import cicada.thrift.client.endpoints.FillDataImplServerCentreRespository;
import cicada.thrift.client.endpoints.FillDataImplServiceFinderType;

/**
 * @author user
 */
@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class EndpointConfig
{
	private static final Map<String, FillData> fillDataStrategies;

	static
	{
		Map<String, FillData> map = new HashMap<String, FillData>();
		map.put("contract", new FillDataImplContract());
		map.put("server", new FillDataImplServer());
		map.put("servicefindertype", new FillDataImplServiceFinderType());
		map.put("servicecentre.respositoryserver", new FillDataImplServerCentreRespository());
		map.put("servicecentre.name", new FillDataImplServerCentreName());
		fillDataStrategies = map;
	}

	public List<EndpointInfo> load() throws Exception
	{
		String cicadaPath=ConfigManager.getCicadaConfigPath();
		Map<String, String> config = PropertyResolverCustom.getConfigProperties(cicadaPath);
		Map<String, EndpointInfo> endpoints = new HashMap<String, EndpointInfo>();
		for (Map.Entry<String, String> entry : config.entrySet())
		{
			String text = entry.getKey();
			String regEx = "^Cicada.Rpc.Client.Endpoints.(\\w+).([\\w.]+)$";
			Pattern pattern = Pattern.compile(regEx, Pattern.CASE_INSENSITIVE);
			Matcher matcher = pattern.matcher(text);
			if (matcher.matches() && matcher.groupCount() == 2)
			{
				EndpointInfo endpointInfo = null;
				String group1 = matcher.group(1);
				if (endpoints.containsKey(group1))
				{
					endpointInfo = endpoints.get(group1);
				}
				else
				{
					endpointInfo = new EndpointInfo();
					endpoints.put(group1, endpointInfo);
				}
				String key = matcher.group(2).toLowerCase();
				if (!EndpointConfig.fillDataStrategies.containsKey(key))
				{
					throw new Exception(String.format("未知的配置，请检查节点%s是否配置正确", text));
				}

				FillData temp = EndpointConfig.fillDataStrategies.get(key);
				String value = entry.getValue();
				boolean result = temp.fill(text, key, value, endpointInfo);
				if (!result)
				{
					throw new Exception(String.format("错误的配置，请检查节点%s是否配置正确", text));
				}
			}
		}

		ArrayList<EndpointInfo> result = new ArrayList<EndpointInfo>(endpoints.values());
		return result;
	}
}
