package cicada.thrift.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import cicada.thrift.client.servicefinders.ServiceFinder;

public class ThriftClientInterceptor implements InvocationHandler
{
	private EndpointInfo _endpointInfo;

	private RpcClient _targetObject;

	private ServiceFinder serviceFinder;

	public ThriftClientInterceptor(EndpointInfo endpointInfo, RpcClient targetObject) throws Exception
	{
		_endpointInfo = endpointInfo;
		serviceFinder = this._endpointInfo.getServerceFinder();
		serviceFinder.init(_endpointInfo);
		_targetObject = targetObject;
	}

	@Override
	public Object invoke(Object proxy, Method method, Object[] args) throws Exception
	{
		excuteBefore();
		Object realClient = _targetObject.GenerateProxyObject();
		Object result = method.invoke(realClient, args);
		excuteAfter();
		return result;
	}

	public void excuteBefore() throws Exception
	{
		_targetObject.before();
	}

	public void excuteAfter()
	{
		_targetObject.after();
	}
}
