/*
 * Decompiled with CFR 0.152.
 */
package cicada.thrift.client.servicefinders;

import cicada.core.RandomUtil;
import cicada.thrift.client.EndpointInfo;
import cicada.thrift.client.model.Address;
import cicada.thrift.client.servicecentre.FindService;
import cicada.thrift.client.servicefinders.ServiceFinder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="servicecentre")
@Scope(value="prototype")
public class ServiceFindersImplCentre
implements ServiceFinder {
    private static final Logger log = Logger.getLogger(ServiceFindersImplCentre.class);
    @Autowired
    private FindService _findService;
    private EndpointInfo _endpointInfo;
    private final List<String> _services = new ArrayList<String>();
    private int _index = -1;

    @Override
    public void init(EndpointInfo endpointInfo) throws Exception {
        this._endpointInfo = endpointInfo;
        String serverAddress = this._endpointInfo.getServiceCentreRespositoryServer();
        this._findService.init(serverAddress, this._endpointInfo.getServiceCentreName(), serviceList -> {
            ServiceFindersImplCentre serviceFindersImplCentre = this;
            synchronized (serviceFindersImplCentre) {
                this._services.clear();
                for (String current : serviceList) {
                    this._services.add(current);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Address getServiceLocation() {
        String text;
        ServiceFindersImplCentre serviceFindersImplCentre = this;
        synchronized (serviceFindersImplCentre) {
            if (this._services.size() == 0) {
                log.info((Object)String.format("\u76ee\u524d\u5728\u4ed3\u5e93%s\u4e0a\uff0c\u6ca1\u6709\u9488\u5bf9%s\u7684\u53ef\u7528\u670d\u52a1", this._endpointInfo.getServiceCentreRespositoryServer(), this._endpointInfo.getServiceCentreName()));
            }
            if (this._index == -1) {
                this._index = this._services.size() == 1 ? 0 : RandomUtil.GetRandomNext((int)this._services.size());
            } else if (this._index > this._services.size() - 1) {
                this._index = 0;
            }
            text = this._services.get(this._index);
            ++this._index;
        }
        String[] array = text.split(":");
        Address address = new Address();
        address.setIp(array[0]);
        address.setPort(Integer.parseInt(array[1]));
        return address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportInvalidServiceLocation(Map<String, Integer> serviceLocation) {
        ServiceFindersImplCentre serviceFindersImplCentre = this;
        synchronized (serviceFindersImplCentre) {
            for (Map.Entry<String, Integer> entry : serviceLocation.entrySet()) {
                this._services.remove(entry.getValue());
            }
        }
    }
}

