/*
 * Decompiled with CFR 0.152.
 */
package cicada.thrift.client;

import cicada.core.Guard;
import cicada.thrift.client.EndpointInfo;
import cicada.thrift.client.model.Address;
import java.lang.reflect.Constructor;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;

public class RpcClient {
    private EndpointInfo _endpointInfo;
    private TTransport transport;

    public RpcClient(EndpointInfo endpointInfo) throws Exception {
        Guard.ThrowIfArgumentIsNull((Object)endpointInfo, (String)"endpointInfo");
        this._endpointInfo = endpointInfo;
    }

    public void before() throws Exception {
        Address address = this._endpointInfo.getServerceFinder().getServiceLocation();
        this.transport = new TSocket(address.getIp(), address.getPort().intValue(), 20000);
        this.transport.open();
    }

    public void after() {
        if (this.transport != null && this.transport.isOpen()) {
            this.transport.close();
        }
    }

    public Object GenerateProxyObject() throws Exception {
        TCompactProtocol tcompactProtocol = new TCompactProtocol(this.transport);
        Class<?> clientType = this._endpointInfo.getClientType();
        Constructor<?> constructor = clientType.getConstructor(TProtocol.class);
        Object result = constructor.newInstance(tcompactProtocol);
        return result;
    }
}

