/*
 * Decompiled with CFR 0.152.
 */
package cicada.thrift.client;

import cicada.thrift.client.EndpointConfig;
import cicada.thrift.client.EndpointInfo;
import cicada.thrift.client.RpcClient;
import cicada.thrift.client.ThriftClientInterceptor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class ThriftClientBoot
implements CommandLineRunner {
    @Autowired
    private EndpointConfig _endpointConfig;
    @Autowired
    ApplicationContext context;

    public void run(String ... args) throws Exception {
        try {
            List<EndpointInfo> list = this._endpointConfig.load();
            if (list != null && list.size() > 0) {
                DefaultListableBeanFactory facotry = (DefaultListableBeanFactory)this.context.getAutowireCapableBeanFactory();
                for (EndpointInfo endpointInfo : list) {
                    RpcClient client = new RpcClient(endpointInfo);
                    ThriftClientInterceptor thriftClientInterceptor = new ThriftClientInterceptor(endpointInfo, client);
                    Class<?> type = endpointInfo.getContractType();
                    Class[] interfaces = new Class[]{type};
                    Object proxy = Proxy.newProxyInstance(client.getClass().getClassLoader(), interfaces, (InvocationHandler)thriftClientInterceptor);
                    String beanName = type.toString();
                    facotry.registerSingleton(beanName, proxy);
                }
            }
        }
        catch (Exception e) {
            String msg = String.format("\u6ce8\u5165cicada_thrift\u5ba2\u6237\u7aef\u51fa\u9519:%s \u8be6\u7ec6\u4fe1\u606f:%s", e.getMessage(), e.getStackTrace());
            throw new Exception(msg);
        }
    }
}

