/**
 * 
 */
package cicada.thrift.client.endpoints;

import cicada.core.BeanFactory;
import cicada.thrift.client.EndpointInfo;
import cicada.thrift.client.servicefinders.ServiceFinder;

/**
 * @author user
 */
public class FillDataImplServiceFinderType implements FillData
{
	@Override
	public boolean fill(String configName, String key, String data, EndpointInfo info) throws Exception
	{
		String text = (data == null || data.isEmpty()) ? "direct" : data.trim();
		text = text.toLowerCase();
		ServiceFinder serviceFinder=BeanFactory.getBeanByName(text);
		if (serviceFinder == null)
		{
			throw new Exception(String.format("您配置Rpc服务发现类型%s是无效的，请修改%s节点", data, configName));
		}
		info.setServiceFinderType(text);
		info.setServerceFinder(serviceFinder);
		return true;
	}
}
