package cicada.thrift.client;

import java.lang.reflect.Proxy;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class ThriftClientBoot implements CommandLineRunner
{
	@Autowired
	private EndpointConfig _endpointConfig;

	@Autowired
	ApplicationContext context;

	@Override
	public void run(String... args) throws Exception
	{
		try
		{
			List<EndpointInfo> list = this._endpointConfig.load();
			if (list != null && list.size() > 0)
			{
				DefaultListableBeanFactory facotry = (DefaultListableBeanFactory) context.getAutowireCapableBeanFactory();
				for (EndpointInfo endpointInfo : list)
				{
					RpcClient client = new RpcClient(endpointInfo);
					ThriftClientInterceptor thriftClientInterceptor = new ThriftClientInterceptor(endpointInfo, client);
					Class<?> type = endpointInfo.getContractType();
					Class<?>[] interfaces = new Class<?>[] { type };
					Object proxy = Proxy.newProxyInstance(client.getClass().getClassLoader(), interfaces, thriftClientInterceptor);
					String beanName = type.toString();
					facotry.registerSingleton(beanName, proxy);
				}
			}
		}
		catch (Exception e)
		{
			String msg = String.format("注入cicada_thrift客户端出错:%s 详细信息:%s", e.getMessage(), e.getStackTrace());
			throw new Exception(msg);
		}
	}
}
