/*
 * Decompiled with CFR 0.152.
 */
package cicada.thrift.client.servicecentre;

import cicada.core.Guard;
import cicada.core.RandomUtil;
import cicada.thrift.client.servicecentre.Finder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class FinderImplZk
implements Finder,
Watcher {
    private static final Logger log = LoggerFactory.getLogger(FinderImplZk.class);
    private static final int repairInterval = 120;
    private static final int timeout = 50000;
    private final ConcurrentHashMap<String, Consumer<List<String>>> _actions = new ConcurrentHashMap();
    private ZooKeeper _zooKeeper;
    private String _respository;

    @Override
    public void init(String respository) throws Exception {
        Guard.ThrowIfArgumentIsNullOrEmpty((String)respository, (String)"respository");
        this._respository = respository;
        try {
            if (this._zooKeeper == null) {
                this.create();
            }
        }
        catch (Exception ex) {
            this.logException(ex);
            this.startRepair();
        }
    }

    private void startRepair() {
    }

    private void create() throws Exception {
        String[] array = this._respository.split(",");
        int radomNum = RandomUtil.GetRandomNext((int)array.length);
        String address = array[radomNum];
        this._zooKeeper = new ZooKeeper(address, 50000, (Watcher)this);
        int num = 10;
        ZooKeeper.States states = this._zooKeeper.getState();
        while (!states.equals((Object)ZooKeeper.States.NOT_CONNECTED) && num-- > 1) {
            Thread.sleep(1000L);
        }
        if (!this._zooKeeper.getState().equals((Object)ZooKeeper.States.CONNECTED)) {
            throw new Exception(String.format("\u8fde\u63a5\u670d\u52a1\u4e2d\u5fc3\u65f6\u53d1\u751f\u8d85\u65f6\uff0czookeeper\u5730\u5740\u4e3a:%s", this._respository));
        }
    }

    private String logException(Exception ex) {
        String text = ex instanceof KeeperException.ConnectionLossException ? String.format("\u65e0\u6cd5\u8fde\u63a5\u5230\u670d\u52a1\u4e2d\u5fc3\uff0czookeeper\u5730\u5740\u4e3a:%s", this._respository) : (ex instanceof KeeperException.SessionExpiredException ? String.format("\u8fde\u63a5\u670d\u52a1\u4e2d\u5fc3\u65f6\u53d1\u751f\u8d85\u65f6\uff0czookeeper\u5730\u5740\u4e3a:%s", this._respository) : String.format("zookeeper\u83b7\u53d6\u8282\u70b9\u6570\u636e\u51fa\u73b0\u5f02\u5e38\uff0czookeeper\u5730\u5740\u4e3a:%s ", this._respository));
        log.error(text);
        return text;
    }

    public void process(WatchedEvent event) {
        Watcher.Event.KeeperState state;
        if (log.isInfoEnabled()) {
            String logText = String.format("ZooKeeper \u72b6\u6001\u53d1\u751f\u66f4\u6539 RPC\u8def\u5f84\uff1a%s \u670d\u52a1\u4e2d\u5fc3\u5730\u5740\uff1a%s event.type:%s event.state%s", event.getPath(), this._respository, event.getType(), event.getState());
            log.info(logText);
        }
        if ((state = event.getState()) != Watcher.Event.KeeperState.Expired) {
            String path = event.getPath();
            try {
                if (path == null || path.isEmpty()) {
                    return;
                }
                this.getData(path, this._actions.get(path));
            }
            catch (InterruptedException | KeeperException ex) {
                this.logException((Exception)ex);
                this.startRepair();
            }
        }
    }

    @Override
    public void add(String path, Consumer<List<String>> serviceListChangedAction) throws Exception {
        Guard.ThrowIfArgumentIsNullOrEmpty((String)path, (String)"path");
        Guard.ThrowIfArgumentIsNull(serviceListChangedAction, (String)"serviceListChangedAction");
        if (this._actions.containsKey(path)) {
            throw new Exception(String.format("\u60a8\u7684\u914d\u7f6e\u6587\u4ef6\u4e2d\u5b58\u5728\u91cd\u590d\u7684Rpc\u8def\u5f84\uff0c\u8def\u5f84\u4e3a:%s", path));
        }
        this._actions.put(path, serviceListChangedAction);
        try {
            if (this._zooKeeper != null && this._zooKeeper.getState().equals((Object)ZooKeeper.States.CONNECTED)) {
                this.getData(path, serviceListChangedAction);
            }
        }
        catch (InterruptedException | KeeperException ex) {
            this.logException((Exception)ex);
            this.startRepair();
        }
    }

    void tryRepair(Object obj) throws InterruptedException {
        log.info("RPC\u670d\u52a1\u4e2d\u5fc3{}\u65ad\u5f00\u8fde\u63a5\uff0c\u5c1d\u8bd5\u8fde\u63a5", (Object)this._respository);
        while (true) {
            try {
                this.repairProcess();
            }
            catch (Exception exception) {
                this.close();
                Thread.sleep(120L);
                continue;
            }
            break;
        }
        log.info("\u5df2\u4e0eRPC\u670d\u52a1\u4e2d\u5fc3{}\u5efa\u7acb\u8fde\u63a5", (Object)this._respository);
    }

    private void getData(String path, Consumer<List<String>> action) throws KeeperException, InterruptedException {
        List result = this._zooKeeper.getChildren(path, (Watcher)this);
        CharSequence[] array = result != null ? result.toArray(new String[result.size()]) : new String[]{};
        String ipList = String.join((CharSequence)",", array);
        log.info("RPC\u8def\u5f84{}\u53d1\u73b0\u6709\u65b0\u7684\u670d\u52a1\u5668\u5217\u8868,\u670d\u52a1\u5668\u5217\u8868\u4e3a\uff1a{}", (Object)path, (Object)ipList);
        if (array.length != 0) {
            action.accept(result);
        }
    }

    private void close() {
        if (this._zooKeeper == null) {
            return;
        }
        try {
            this._zooKeeper.close();
            this._zooKeeper = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void repairProcess() throws Exception {
        if (this._zooKeeper != null && !this._zooKeeper.getState().isAlive()) {
            this.close();
        }
        try {
            if (this._zooKeeper == null) {
                this.create();
            }
            this.getDataList();
        }
        catch (Exception ex) {
            String log = this.logException(ex);
            throw new Exception(log);
        }
    }

    private void getDataList() throws KeeperException, InterruptedException {
        for (Map.Entry<String, Consumer<List<String>>> entry : this._actions.entrySet()) {
            this.getData(entry.getKey(), entry.getValue());
        }
    }
}

