/*
 * Decompiled with CFR 0.152.
 */
package cicada.thrift.server;

import cicada.core.BeanFactory;
import cicada.thrift.server.RpcServer;
import cicada.thrift.server.ServerConfiguration;
import cicada.thrift.zookeeper.ConnectionFailProcessMode;
import cicada.thrift.zookeeper.ServicePublisher;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class RpcServerImpl
implements RpcServer,
DisposableBean {
    private static final int ClientTimeoutDefault = 300000;
    private static final int MinThreadsDefault = 10;
    private static final int MaxThreadsDefault = 10000;
    private ServerConfiguration _serverConfiguration;
    private ServicePublisher _servicePublisher;
    private static final Logger log = LoggerFactory.getLogger(RpcServerImpl.class);
    private boolean _published;
    private TServer _server;

    public RpcServerImpl(ServerConfiguration serverConfiguration, ServicePublisher servicePublisher) {
        this._serverConfiguration = serverConfiguration;
        this._servicePublisher = servicePublisher;
        String respositoryServer = this._serverConfiguration.getPublishRespositoryServer();
        ConnectionFailProcessMode connectionFailProcessMode = this._serverConfiguration.getConnectionFailProcessMode();
        String publishName = this._serverConfiguration.getPublishName();
        String publishServer = this._serverConfiguration.getPublishServer();
        int port = this._serverConfiguration.getPort();
        this._servicePublisher.Init(respositoryServer, connectionFailProcessMode, publishName, publishServer + ":" + port);
    }

    @Override
    public <T> void run(Class<T> classzz) {
        if (!classzz.isInterface() || classzz == null) {
            log.info("{}\u4e0d\u662f\u63a5\u53e3", (Object)classzz.getName());
            return;
        }
        String processorName = classzz.getName().replace("Iface", "") + "Processor";
        ThriftSevice<T> runPrivateRunnable = new ThriftSevice<T>(processorName, classzz);
        Thread privateRunable = new Thread(runPrivateRunnable);
        privateRunable.start();
        PublishRunable publishRunable = new PublishRunable();
        Thread threadPublish = new Thread(publishRunable);
        threadPublish.start();
    }

    @Override
    public void close() {
        if (this._published) {
            this._servicePublisher.cancel();
        }
        if (this._server != null) {
            this._server.stop();
        }
    }

    public void destroy() throws Exception {
        try {
            if (this._servicePublisher != null) {
                this._servicePublisher.destroy();
                this._servicePublisher = null;
            }
            if (this._server != null) {
                this._server.stop();
                this._server = null;
            }
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
    }

    public class ThriftSevice<T>
    implements Runnable {
        private String _processorName;
        private Class<T> _classzz;

        public ThriftSevice(String processorName, Class<T> classzz) {
            this._processorName = processorName;
            this._classzz = classzz;
        }

        @Override
        public void run() {
            try {
                Class<?> classProcess = Class.forName(this._processorName);
                Object iface = BeanFactory.getBeanByType(this._classzz);
                Constructor<?> constructor = classProcess.getConstructor(this._classzz);
                TProcessor tprocessor = (TProcessor)constructor.newInstance(iface);
                TServerSocket serverTransport = new TServerSocket(RpcServerImpl.this._serverConfiguration.getPort(), 300000);
                TThreadPoolServer.Args tArgs = new TThreadPoolServer.Args((TServerTransport)serverTransport);
                tArgs.processor(tprocessor);
                tArgs.protocolFactory((TProtocolFactory)new TCompactProtocol.Factory());
                tArgs.maxWorkerThreads = 10000;
                tArgs.minWorkerThreads = 10;
                tArgs.inputTransportFactory(new TTransportFactory());
                tArgs.outputTransportFactory(new TTransportFactory());
                RpcServerImpl.this._server = (TServer)new TThreadPoolServer(tArgs);
                RpcServerImpl.this._server.serve();
            }
            catch (ClassNotFoundException e) {
                log.info("\u6ca1\u6709\u53d1\u73b0\u5c06\u8981\u5411\u5916\u516c\u5f00\u7684\u670d\u52a1\u63a5\u53e3,\u8bf7\u786e\u4fdd\u60a8\u7528\u7684\u662fThrift\u751f\u6210\u7684\u670d\u52a1\u63a5\u53e3");
            }
            catch (TTransportException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public class PublishRunable
    implements Runnable {
        @Override
        public void run() {
            if (RpcServerImpl.this._serverConfiguration.getPublishRespositoryServer() == null || RpcServerImpl.this._serverConfiguration.getPublishRespositoryServer().isEmpty()) {
                return;
            }
            RpcServerImpl.this._published = true;
            try {
                Thread.sleep(5000L);
                RpcServerImpl.this._servicePublisher.publish();
            }
            catch (InterruptedException e) {
                String mString = String.format("rpc \u53d1\u5e03\u670d\u52a1\u51fa\u9519:%s", e.getMessage());
                log.error(mString, (Throwable)e);
            }
        }
    }
}

