/*
 * Decompiled with CFR 0.152.
 */
package cicada.thrift.zookeeper;

import cicada.core.RandomUtil;
import cicada.thrift.zookeeper.ConnectionFailProcessMode;
import cicada.thrift.zookeeper.ServicePublisher;
import java.io.IOException;
import java.util.List;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ServicePublisherImpl
implements ServicePublisher,
Watcher,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(ServicePublisherImpl.class);
    private static final int repairInterval = 10000;
    private static final int timeout = 10000;
    private ZooKeeper _zooKeeper;
    private String _respository;
    private ConnectionFailProcessMode _mode;
    private String _path;
    private String _dataPath;
    private boolean _running;

    @Override
    public void Init(String respository, ConnectionFailProcessMode mode, String path, String data) {
        this._respository = respository;
        this._mode = mode;
        this._path = path == null || path.isEmpty() || !path.substring(0, 1).equals("/") ? "/" + path : path;
        this._dataPath = this._path.concat("/").concat(data);
    }

    @Override
    public void publish() {
        this._running = true;
        this.StartRepair();
    }

    @Override
    public void cancel() {
        this._running = false;
    }

    public void process(WatchedEvent event) {
        Watcher.Event.KeeperState state;
        if (log.isInfoEnabled()) {
            log.info(String.format("ZooKeeper \u72b6\u6001\u53d1\u751f\u66f4\u6539 \u670d\u52a1\u4e2d\u5fc3\u5730\u5740\uff1a%s event.type:%s event.state:%s", this._respository, event.getType(), event.getState()));
        }
        if ((state = event.getState()) != Watcher.Event.KeeperState.Expired) {
            switch (state) {
                case Unknown: {
                    break;
                }
                case Disconnected: {
                    break;
                }
                case NoSyncConnected: {
                    break;
                }
                default: {
                    try {
                        this.validateExistPath();
                    }
                    catch (Exception ex) {
                        this.logException(ex);
                        this.failProcess();
                    }
                    return;
                }
            }
        }
    }

    private void StartRepair() {
        RepairThread repair = new RepairThread();
        Thread thread = new Thread(repair);
        thread.start();
    }

    void tryRepair(Object obj) throws InterruptedException {
        log.info(String.format("RPC\u670d\u52a1\u4e2d\u5fc3%s\u65ad\u5f00\u8fde\u63a5\uff0c\u5c1d\u8bd5\u8fde\u63a5", this._respository));
        int count = 0;
        while (this._running) {
            if (count > 10) {
                log.info(String.format("\u4e0d\u80fd\u4e0eRPC\u670d\u52a1\u4e2d\u5fc3%s\u94fe\u63a5\u6210\u529f\uff0c\u7cfb\u7edf\u5c06\u505c\u6b62\u81ea\u52a8\u5c1d\u8bd5!", this._respository));
                break;
            }
            try {
                this.repairProcess();
                log.info(String.format("\u5df2\u4e0eRPC\u670d\u52a1\u4e2d\u5fc3%s\u5efa\u7acb\u8fde\u63a5", this._respository));
                break;
            }
            catch (Exception ex) {
                this.close();
                Thread.sleep(10000L);
                log.error(String.format("RPC \u5efa\u7acb\u94fe\u63a5\u51fa\u9519:%s,\u8be6\u7ec6\u4fe1\u606f:%s", ex.getMessage(), ex.getStackTrace()));
                ++count;
            }
        }
    }

    private void failProcess() {
        ConnectionFailProcessMode mode = this._mode;
        if (mode == ConnectionFailProcessMode.Retry) {
            this.StartRepair();
            return;
        }
        if (mode != ConnectionFailProcessMode.Throw) {
            return;
        }
        log.error(String.format("\u4e0e\u670d\u52a1\u4e2d\u5fc3%s\u65ad\u5f00\u8fde\u63a5", this._respository));
    }

    private void repairProcess() throws Exception {
        if (this._zooKeeper != null && !this._zooKeeper.getState().isAlive()) {
            this.close();
            Thread.sleep(120000L);
        }
        if (this._zooKeeper == null) {
            this.create();
        }
        ZKPaths.mkdirs((ZooKeeper)this._zooKeeper, (String)this._path);
        this._zooKeeper.create(this._dataPath, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        this.validateExistPath();
    }

    private void validateExistPath() throws KeeperException, InterruptedException, Exception {
        if (this._zooKeeper == null || this._zooKeeper.exists(this._dataPath, (Watcher)this) == null) {
            throw new Exception("\u8282\u70b9\u4e0d\u5b58\u5728");
        }
    }

    private String logException(Exception ex) {
        String text = ex instanceof KeeperException.ConnectionLossException ? String.format("\u65e0\u6cd5\u8fde\u63a5\u5230\u670d\u52a1\u4e2d\u5fc3\uff0c\u5730\u5740\u4e3a:%s", this._respository) : (ex instanceof KeeperException.SessionExpiredException ? String.format("\u8fde\u63a5\u670d\u52a1\u4e2d\u5fc3\u65f6\u53d1\u751f\u8d85\u65f6\uff0c\u5730\u5740\u4e3a:%s", this._respository) : String.format("RPC zookeeper\u6ce8\u518c\u8282\u70b9\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u5730\u5740\u4e3a:%s", this._respository));
        log.error(text);
        return text;
    }

    private void create() throws InterruptedException, IOException {
        String[] array = this._respository.split(",");
        String connectString = array[RandomUtil.GetRandomNext((int)array.length)];
        this._zooKeeper = new ZooKeeper(connectString, 10000, (Watcher)this);
        int num = 10;
        while (!this._zooKeeper.getState().equals((Object)ZooKeeper.States.CONNECTED) && num-- > 1) {
            Thread.sleep(1000L);
        }
    }

    private void close() {
        if (this._zooKeeper == null) {
            return;
        }
        try {
            this._zooKeeper.close();
            this._zooKeeper = null;
        }
        catch (Exception ex) {
            String mString = String.format("\u5173\u95edzookerper\u670d\u52a1\u51fa\u9519:%s", ex.getMessage());
            log.error(mString, (Throwable)ex);
        }
    }

    public void destroy() throws Exception {
        this.close();
    }

    public class RepairThread
    implements Runnable {
        @Override
        public void run() {
            try {
                ServicePublisherImpl.this.tryRepair(new Object());
            }
            catch (InterruptedException e) {
                String mString = String.format("\u4fee\u590dzookeeper\u51fa\u9519,%s", e.getMessage());
                log.error(mString, (Throwable)e);
            }
        }
    }
}

