/*
 * Decompiled with CFR 0.152.
 */
package cicada.thrift.server;

import cicada.thrift.zookeeper.ConnectionFailProcessMode;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class ServerConfiguration {
    private final String PORT_CONFIGN_AME = "Cicada.Rpc.Server.Port";
    private final String PUBLISH_RESPOSITORY_SERVERCONFIGNAME = "Cicada.Rpc.Server.ServiceCentre.RespositoryServer";
    private final String PUBLISHNAME_CONFIGNAME = "Cicada.Rpc.Server.ServiceCentre.Name";
    private final String PUBLISH_SERVER_CONFIGNAME = "Cicada.Rpc.Server.ServiceCentre.Server";
    private final String CONNECTION_FAIL_PROCESSMODE_CONFIGNAME = "Cicada.Rpc.Server.ServiceCentre.ConnectionFailProcessMode";
    private Environment _configurationDataRespository;
    private int port;
    private String publishRespositoryServer;
    private String publishName;
    private String publishServer;
    private ConnectionFailProcessMode ConnectionFailProcessMode;

    public int getPort() {
        return this.port;
    }

    public String getPublishRespositoryServer() {
        return this.publishRespositoryServer;
    }

    public String getPublishName() {
        return this.publishName;
    }

    public String getPublishServer() {
        return this.publishServer;
    }

    public ConnectionFailProcessMode getConnectionFailProcessMode() {
        return this.ConnectionFailProcessMode;
    }

    public ServerConfiguration(Environment env) throws Exception {
        this._configurationDataRespository = env;
        this.setPort();
        this.setPublishRespositoryServer();
        if (this.publishRespositoryServer != null && !this.publishRespositoryServer.isEmpty()) {
            this.setPublishName();
            this.setPublishServer();
        }
        this.setConnectionFailProcessMode();
    }

    private void setPort() throws Exception {
        String strPort = this._configurationDataRespository.getProperty("Cicada.Rpc.Server.Port");
        if (strPort != null && !strPort.isEmpty()) {
            this.port = Integer.parseInt(strPort.trim());
        }
        if (this.port == 0) {
            throw new Exception(String.format("\u8bf7\u4e3aRPC\u670d\u52a1\u5668\u914d\u7f6e\u7aef\u53e3\uff0c\u8bf7\u4fee\u6539\u914d\u7f6e\u9879%s", "Cicada.Rpc.Server.Port"));
        }
    }

    private void setPublishRespositoryServer() {
        String text = this._configurationDataRespository.getProperty("Cicada.Rpc.Server.ServiceCentre.RespositoryServer");
        this.publishRespositoryServer = text == null || text.isEmpty() ? "" : text.trim();
    }

    private void setPublishName() throws Exception {
        String text = this._configurationDataRespository.getProperty("Cicada.Rpc.Server.ServiceCentre.Name");
        if (text == null || text.isEmpty()) {
            throw new Exception(String.format("\u8bf7\u4e3aRPC\u670d\u52a1\u5668\u914d\u7f6e\u53d1\u5e03\u540d\u79f0\uff0c\u8bf7\u4fee\u6539\u914d\u7f6e\u9879%s", "Cicada.Rpc.Server.ServiceCentre.Name"));
        }
        this.publishName = text.trim();
    }

    private void setPublishServer() throws Exception {
        String text = this._configurationDataRespository.getProperty("Cicada.Rpc.Server.ServiceCentre.Server");
        if (text == null || text.isEmpty()) {
            throw new Exception(String.format("\u8bf7\u4e3aRPC\u670d\u52a1\u5668\u914d\u7f6e\u53d1\u5e03\u670d\u52a1\u5668\u5730\u5740\uff0c\u8bf7\u4fee\u6539\u914d\u7f6e\u9879%s", "Cicada.Rpc.Server.ServiceCentre.Server"));
        }
        this.publishServer = text.trim();
    }

    private void setConnectionFailProcessMode() throws Exception {
        String value = this._configurationDataRespository.getProperty("Cicada.Rpc.Server.ServiceCentre.ConnectionFailProcessMode");
        ConnectionFailProcessMode connectionFailProcessMode = cicada.thrift.zookeeper.ConnectionFailProcessMode.Retry;
        if (value == null || value.isEmpty()) {
            this.ConnectionFailProcessMode = connectionFailProcessMode;
        } else {
            if (!value.equals(cicada.thrift.zookeeper.ConnectionFailProcessMode.Retry.toString())) {
                if (!value.equals(cicada.thrift.zookeeper.ConnectionFailProcessMode.Throw.toString())) {
                    throw new Exception(String.format("\u60a8\u4e3a\u8fde\u63a5\u6ce8\u518c\u4e2d\u5fc3\u51fa\u73b0\u9519\u8bef\u65f6\u914d\u7f6e\u7684\u5904\u7406\u65b9\u5f0f\u65e0\u6548\uff0c\u5fc5\u987b\u4e3aThrow\u6216\u8005Retry\uff0c\u8bf7\u4fee\u6539\u914d\u7f6e\u9879%s", "Cicada.Rpc.Server.ServiceCentre.ConnectionFailProcessMode"));
                }
            }
            this.ConnectionFailProcessMode = value.equals(cicada.thrift.zookeeper.ConnectionFailProcessMode.Retry.toString()) ? cicada.thrift.zookeeper.ConnectionFailProcessMode.Retry : cicada.thrift.zookeeper.ConnectionFailProcessMode.Throw;
        }
    }
}

