/*
 * Decompiled with CFR 0.152.
 */
package cicada.id;

import cicada.core.BeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
@Scope(value="singleton")
public class SnowFlake {
    private final long twepoch = 1420041600000L;
    private final long workerIdBits = 5L;
    private final long datacenterIdBits = 5L;
    private final long maxWorkerId = 31L;
    private final long maxDatacenterId = 31L;
    private final long sequenceBits = 12L;
    private final long workerIdShift = 12L;
    private final long datacenterIdShift = 17L;
    private final long timestampLeftShift = 22L;
    private final long sequenceMask = 4095L;
    private long workerId;
    private long datacenterId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    private long dbMaxId;
    private long dbMaxIdCurrent;
    private long tbMaxId;
    private final byte[] lock = new byte[1];

    private SnowFlake() {
        Environment environment = (Environment)BeanFactory.getBeanByType(Environment.class);
        String strDatacenterId = environment.getProperty("DatacenterId");
        String strWorkerId = environment.getProperty("WorkerId");
        String strdbMaxId = environment.getProperty("DbMaxId");
        String strdbMaxId_Current = environment.getProperty("DbMaxId.Current");
        String strtbMaxId = environment.getProperty("TbMaxId");
        if (strDatacenterId != null && !strDatacenterId.isEmpty()) {
            this.datacenterId = Long.valueOf(strDatacenterId);
        }
        if (strWorkerId != null && !strWorkerId.isEmpty()) {
            this.workerId = Long.valueOf(strDatacenterId);
        }
        if (strdbMaxId != null && !strdbMaxId.isEmpty()) {
            this.dbMaxId = Long.valueOf(strdbMaxId);
        }
        if (strtbMaxId != null && !strtbMaxId.isEmpty()) {
            this.tbMaxId = Long.valueOf(strtbMaxId);
        }
        if (strdbMaxId_Current != null && !strdbMaxId_Current.isEmpty()) {
            this.dbMaxIdCurrent = Long.valueOf(strdbMaxId_Current);
        }
        if (this.workerId > 31L || this.workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 31L));
        }
        if (this.datacenterId > 31L || this.datacenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", 31L));
        }
        if (this.dbMaxId > 99L || this.dbMaxId < 0L) {
            throw new IllegalArgumentException(String.format("dbMaxId  can't be greater than %d or less than 0", 99));
        }
        if (this.tbMaxId > 9L || this.tbMaxId < 0L) {
            throw new IllegalArgumentException(String.format("tbMaxId  can't be greater than %d or less than 0", 9));
        }
        if (this.dbMaxIdCurrent > this.dbMaxId || this.dbMaxIdCurrent < 0L) {
            throw new IllegalArgumentException(String.format("dbMaxIdCurrent can't be greater than %d or less than 0", this.dbMaxId));
        }
        if (this.dbMaxId > this.dbMaxIdCurrent && this.dbMaxId % this.dbMaxIdCurrent != 0L) {
            throw new IllegalArgumentException("dbMaxId % dbMaxIdCurrent must  == 0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIdWithDb() {
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            long id = this.generateId();
            if (this.dbMaxId == 0L) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return String.valueOf(id);
            }
            String dbId = this.dbIdInfo(id);
            String result = String.format("%s%s", dbId, id);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getId() {
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            long result = this.generateId();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return String.valueOf(result);
        }
    }

    private long generateId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        long result = timestamp - 1420041600000L << 22 | this.datacenterId << 17 | this.workerId << 12 | this.sequence;
        return result;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }

    private String dbIdInfo(long id) {
        long dbInfo = id / (this.tbMaxId + 1L) % this.dbMaxId + 1L;
        if (this.dbMaxId > this.dbMaxIdCurrent) {
            dbInfo = (dbInfo - 1L) % this.dbMaxIdCurrent + 1L;
        }
        long tbInfo = id % (this.tbMaxId + 1L);
        String strDbInfo = String.valueOf(dbInfo);
        if (strDbInfo.length() < 2) {
            strDbInfo = String.format("0%s", strDbInfo);
        }
        String result = String.format("%s%s", strDbInfo, tbInfo);
        return result;
    }
}

