/*
 * Decompiled with CFR 0.152.
 */
package cicada.id;

import cicada.core.BeanFactory;
import cicada.core.FileUtil;
import cicada.core.TimeUtil;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@Scope(value="singleton")
public class IdOfDay {
    private Logger logger = LoggerFactory.getLogger(IdOfDay.class);
    private final long twepoch = 17683L;
    private final long datacenterIdBits = 3L;
    private final long workerIdBits = 5L;
    private long sequenceBits;
    private long workerIdShift = this.sequenceBits = 9L;
    private long datacenterIdShift = this.workerIdShift + 5L;
    private long timestampLeftShift = this.datacenterIdShift + 3L;
    private long sequenceMask = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)this.sequenceBits;
    private long datacenterId = 0L;
    private final long maxDatacenterId = 7L;
    private long workerId = 0L;
    private final long maxWorkerId = 31L;
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    private long timestamp = TimeUtil.currentTimeMillis() / 1000L / 86400L;
    private String rootPath = FileUtil.rootPath();
    private File fileSeq = null;
    private final byte[] lock = new byte[1];
    private final byte[] perLock = new byte[1];
    private long temp = -1L;

    private IdOfDay() throws IOException {
        Environment environment = (Environment)BeanFactory.getBeanByType(Environment.class);
        String strDatacenterId = environment.getProperty("DatacenterId");
        String strWorkerId = environment.getProperty("WorkerId");
        if (strDatacenterId != null && !strDatacenterId.isEmpty()) {
            this.datacenterId = Long.valueOf(strDatacenterId);
        }
        if (strWorkerId != null && !strWorkerId.isEmpty()) {
            this.workerId = Long.valueOf(strDatacenterId);
        }
        if (this.workerId > 31L || this.workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 31L));
        }
        if (this.datacenterId > 7L || this.datacenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", 7L));
        }
        this.createSeqFile();
        this.initSeq();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getId() {
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            long result = this.generateId();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    private long generateId() {
        if (this.lastTimestamp == this.timestamp) {
            ++this.sequence;
            this.resetLentgth(this.sequence);
            this.sequence &= this.sequenceMask;
            this.timestamp = TimeUtil.currentTimeMillis() / 1000L / 86400L;
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = this.timestamp;
        long result = this.timestamp - 17683L << (int)this.timestampLeftShift | this.datacenterId << (int)this.datacenterIdShift | this.workerId << (int)this.workerIdShift | this.sequence;
        return result;
    }

    private void resetLentgth(long value) {
        int length = (int)Math.ceil(Math.log(value + 1L) / Math.log(2.0));
        this.sequenceBits = length;
        if (this.sequenceBits < 9L) {
            this.sequenceBits = 9L;
        }
        this.workerIdShift = this.sequenceBits;
        this.datacenterIdShift = this.workerIdShift + 5L;
        this.timestampLeftShift = this.datacenterIdShift + 3L;
        this.sequenceMask = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)this.sequenceBits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="0/20 * * * * *")
    private void persistence() {
        byte[] byArray = this.perLock;
        synchronized (this.perLock) {
            if (this.temp != this.sequence && this.lastTimestamp != -1L) {
                String data = String.format("%s,%s", this.lastTimestamp, this.sequence);
                try {
                    FileUtil.write((String)data, (File)this.fileSeq);
                    this.temp = this.sequence;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void createSeqFile() {
        this.logger.info("\u9879\u76ee\u76ee\u5f55:" + this.rootPath);
        if (this.rootPath != null) {
            this.rootPath = this.rootPath.length() == 0 ? "sequence" : String.format("%s%s", this.rootPath, "sequence");
            this.fileSeq = new File(this.rootPath);
            if (!this.fileSeq.exists()) {
                try {
                    this.fileSeq.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void initSeq() {
        try {
            String per = FileUtil.file2String((File)this.fileSeq);
            if (per != null && !per.isEmpty()) {
                String[] array = per.split(",");
                String lastTimeStr = array[0];
                String seqStr = array[1];
                if (lastTimeStr != null && !lastTimeStr.isEmpty()) {
                    this.lastTimestamp = Long.valueOf(lastTimeStr);
                }
                if (seqStr != null && !seqStr.isEmpty()) {
                    this.sequence = Long.valueOf(seqStr);
                    ++this.sequence;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

