package cicada.core.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value = { "file:config/cicada-${spring.profiles.active}.properties", "config/cicada-${spring.profiles.active}.properties", "file:config/cicada.properties", "config/cicada.properties" }, ignoreResourceNotFound = true, encoding = "UTF-8")
public class RootConfig
{
	// private static Logger logger = LoggerFactory.getLogger(RootConfig.class);
	//
	// public static final String SPRING_CONFIG_LOCATION =
	// "spring.config.location";
	//
	// @Bean
	// public static PropertyPlaceholderConfigurer properties() throws
	// UnsupportedEncodingException, IOException
	// {
	// final PropertyPlaceholderConfigurer ppc = new
	// PropertyPlaceholderConfigurer();
	// ppc.setIgnoreResourceNotFound(true);
	// final List<Resource> resourceLst = new ArrayList<Resource>();
	//
	// if (System.getProperty(SPRING_CONFIG_LOCATION) != null)
	// {
	// String configFilePath = System.getProperty(SPRING_CONFIG_LOCATION);
	// String[] configFiles = configFilePath.split(",|;");
	//
	// FileSystemResource res = null;
	// for (String configFile : configFiles)
	// {
	// if (configFile.startsWith("file:"))
	// {
	// resourceLst.add(new FileSystemResource(configFile));
	// }
	// else
	// {
	// resourceLst.add(new ClassPathResource(configFile));
	// }
	// }
	// }
	// else
	// {
	// resourceLst.add(new ClassPathResource("config/cicada.properties"));
	// }
	// ppc.setLocations(resourceLst.toArray(new Resource[] {}));
	// return ppc;

	// }

	private Properties getProperties(File file) throws FileNotFoundException, IOException
	{
		Properties prop = new Properties();
		try (FileInputStream in = new FileInputStream(file))
		{
			try (InputStreamReader reader = new InputStreamReader(in, "UTF-8"))
			{
				prop.load(reader);
				return prop;
			}
		}
	}
}
