package cicada.core;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyResolverCustom
{
	private final static Logger log = LoggerFactory.getLogger(PropertyResolverCustom.class);

	public static Map<String, String> getConfigProperties(String fileFullPath)
	{
		Map<String, String> result = new HashMap<String, String>();
		Properties properties = new Properties();
		try (InputStream inputStream = getFileStream(fileFullPath))
		{
			try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8"))
			{
				properties.load(inputStream);
			}
			Enumeration<?> keys = properties.propertyNames();
			while (keys.hasMoreElements())
			{
				String key = (String) keys.nextElement();
				String value = properties.getProperty(key);
				result.put(key, value);
			}
		}
		catch (Exception e)
		{
			log.error("解析属性文件:{}出错:{},详细信息:{}", fileFullPath, e.getMessage(), e.getStackTrace());
		}
		return result;
	}

	private static InputStream getFileStream(String fileFullPath) throws FileNotFoundException
	{
		InputStream inputStream = PropertyResolverCustom.class.getClassLoader().getResourceAsStream(fileFullPath.toLowerCase());
		if (inputStream == null)
		{
			inputStream = new FileInputStream(fileFullPath);
		}
		return inputStream;
	}
}
