package cicada.core;

import java.io.IOException;
import java.util.List;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;

/**
 * @author user
 */
public class JsonUtil
{

	static ObjectMapper mapper = new ObjectMapper();

	public static <T> List<T> String2List(String json, Class<T> obj) throws JsonParseException, JsonMappingException, IOException
	{
		JavaType javaType = mapper.getTypeFactory().constructParametricType(List.class, obj);
		List<T> result = mapper.readValue(json, javaType);
		return result;
	}

	public static <T> T String2Obj(String json, Class<T> obj) throws JsonParseException, JsonMappingException, IOException
	{
		// T result=new Main<User>().jsonConverObject(josn3, User.class); 对象里有
		// 集合 转换
		T result = mapper.readValue(json, obj);
		return result;
	}

	public static <T> String obj2string(T obj) throws JsonProcessingException
	{
		if (obj == null)
		{
			return "";
		}
		String result = mapper.writeValueAsString(obj);
		return result;
	}

	public static <T> byte[] obj2byte(T obj) throws JsonProcessingException
	{
		if (obj == null)
		{
			return null;
		}
		byte[] result = mapper.writeValueAsBytes(obj);
		return result;
	}
}
