/*
 * Decompiled with CFR 0.152.
 */
package cicada.core;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyResolverCustom {
    private static final Logger log = LoggerFactory.getLogger(PropertyResolverCustom.class);

    public static Map<String, String> getConfigProperties(String fileFullPath) {
        HashMap<String, String> result = new HashMap<String, String>();
        Properties properties = new Properties();
        try (InputStream inputStream = PropertyResolverCustom.getFileStream(fileFullPath);){
            try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");){
                properties.load(inputStream);
            }
            Enumeration<?> keys = properties.propertyNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = properties.getProperty(key);
                result.put(key, value);
            }
        }
        catch (Exception e) {
            log.error("\u89e3\u6790\u5c5e\u6027\u6587\u4ef6:{}\u51fa\u9519:{},\u8be6\u7ec6\u4fe1\u606f:{}", new Object[]{fileFullPath, e.getMessage(), e.getStackTrace()});
        }
        return result;
    }

    private static InputStream getFileStream(String fileFullPath) throws FileNotFoundException {
        InputStream inputStream = PropertyResolverCustom.class.getClassLoader().getResourceAsStream(fileFullPath.toLowerCase());
        if (inputStream == null) {
            inputStream = new FileInputStream(fileFullPath);
        }
        return inputStream;
    }
}

