package cicada.core;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class TimeUtil
{

	/**
	 * 获取当前时间的时间戳(毫秒级)
	 * 
	 * @return
	 */
	public static long currentTimeMillis()
	{
		long result = System.currentTimeMillis();
		return result;
	}

	/**
	 * 获取当前时间
	 * 
	 * @return
	 */
	public static String currentDate()
	{
		Date date = new Date();
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat(Definition.dateFormat);
		String result = simpleDateFormat.format(date);
		return result;
	}

	/**
	 * 日期转换为时间戳(毫秒级)
	 * 
	 * @return
	 * @throws ParseException
	 */
	public static long date2Stamp(String date) throws ParseException
	{
		long result = date2Stamp(date, Definition.dateFormat);
		return result;
	}
	

	/**
	 * 日期转换为时间戳(毫秒级)
	 * 
	 * @return
	 * @throws ParseException
	 */
	public static long date2Stamp(String date, String format) throws ParseException
	{
		DateFormat dateFormat = new SimpleDateFormat(format);
		Date time = dateFormat.parse(date);
		Calendar cal = Calendar.getInstance();
		cal.setTime(time);
		long result = cal.getTimeInMillis();
		return result;
	}

	/**
	 * 时间戳转为日期
	 * 
	 * @param smamp
	 * @return
	 */
	public static String stamp2Date(Long smamp, String format)
	{
		SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
		Date date = new Date(smamp);
		String result = simpleDateFormat.format(date);
		return result;
	}

	/**
	 * 时间戳转为日期
	 * 
	 * @param smamp
	 * @return
	 */
	public static String stamp2Date(Long smamp)
	{
		String result = stamp2Date(smamp, Definition.dateFormat);
		return result;
	}
}
