/*
 * Decompiled with CFR 0.152.
 */
package cicada.core;

public class StringUtil {
    public static String DefaultIfNull(String src, String defaultValue) {
        if (src == null) {
            return defaultValue;
        }
        return src;
    }

    public static String DefaultIfNullOrEmpty(String src, String defaultValue) {
        if (src.isEmpty() || src == null) {
            return defaultValue;
        }
        return src;
    }

    public static String ReplaceWhiteSpace(String src, String newValue, Boolean repeated) {
        if (src.isEmpty() || src == null) {
            return src;
        }
        int num = Integer.MIN_VALUE;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (Character.isWhitespace(c)) {
                if (repeated.booleanValue()) {
                    stringBuilder.append(newValue);
                    continue;
                }
                if (num != i - 1) {
                    stringBuilder.append(newValue);
                }
                num = i;
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String TrimStart(String src, String start, Boolean ignoreCase) {
        String text = src;
        int len = start.length();
        if (ignoreCase.booleanValue()) {
            String startTemp = text.substring(0, len);
            if (startTemp.equalsIgnoreCase(start)) {
                text = text.substring(len);
            }
        } else if (text.startsWith(start)) {
            text = text.substring(len);
        }
        return text;
    }

    public static String TrimEnd(String src, String end, Boolean ignoreCase) {
        String text = src;
        int len = end.length();
        int totalLen = text.length();
        if (ignoreCase.booleanValue()) {
            String endTemp = text.substring(totalLen - len, len);
            if (endTemp.equalsIgnoreCase(end)) {
                text = text.substring(0, totalLen - len);
            }
        } else if (text.endsWith(end)) {
            text = text.substring(0, totalLen - len);
        }
        return text;
    }
}

