package cicada.core;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FileUtils
{
	/**
	 * 获取项目根目录 默认返回根目录 例如"/tmp/123/ 但有可能存在空格 " 如果运行在jar包里面 返回""
	 * 
	 * @return
	 */
	public static String rootPath()
	{
		try
		{
			String path = FileUtils.class.getClassLoader().getResource("").getPath();
			return path;
		}
		catch (Exception e)
		{
			return "";
		}
	}

	/**
	 * 文件转成bytes[]
	 * 
	 * @param filePath
	 * @return
	 * @throws FileNotFoundException
	 * @throws IOException
	 */
	public static byte[] file2bytes(final String filePath) throws FileNotFoundException, IOException
	{
		try (FileInputStream fileInputStream = new FileInputStream(filePath))
		{
			try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1000))
			{
				byte[] bytes = new byte[1000];
				int n = -1;
				while ((n = fileInputStream.read(bytes)) != -1)
				{
					byteArrayOutputStream.write(bytes, 0, n);
				}
				byte[] buffer = byteArrayOutputStream.toByteArray();
				return buffer;
			}
		}
	}

	/**
	 * byte[] 转文件
	 * @param bytes
	 * @param filePath
	 * @return
	 * @throws FileNotFoundException
	 * @throws IOException
	 */
	public static File byte2file(byte[] bytes, final String filePath) throws FileNotFoundException, IOException
	{
		File file = new File(filePath);
		try (OutputStream outputStream = new FileOutputStream(file))
		{
			try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream))
			{
				bufferedOutputStream.write(bytes);
				return file;
			}
		}
	}
}
