package cicada.core.config;

import java.io.File;

import org.springframework.core.env.Environment;

import cicada.core.BeanFactory;

public class ConfigManager
{
	public static String getCicadaConfigPath()
	{
		return cicadaConfigPath;
	}

	private ConfigManager()
	{
	}

	private static final String cicadaConfigPath;

	static
	{
		cicadaConfigPath = getConfigFile();
	}

	private static String getConfigFile()
	{
		Environment env = BeanFactory.getBeanByType(Environment.class);
		String prux = env.getProperty("spring.profiles.active");
		if (prux != null && !prux.equals(null) && !prux.isEmpty())
		{
			String cicadaPath = String.format("config/cicada%s%s.properties", "-", prux);
			File file = new File(cicadaPath);
			if (file.exists())
			{
				return cicadaPath;
			}
		}
		return "config/cicada.properties";
	}
}
