package cicada.core.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value = { "file:config/cicada.properties", "config/cicada.properties" }, ignoreResourceNotFound = true, encoding = "UTF-8")
public class RootConfig
{
	public Properties loadCicada() throws UnsupportedEncodingException, IOException
	{
		String configFilePath = ConfigManager.getCicadaConfigPath();
		File file = new File(configFilePath);
		if (file.isFile() && file.exists())
		{
			Properties result = getProperties(file);
			return result;
		}
		throw new FileNotFoundException("缺少cicada.properties 文件");
	}

	private Properties getProperties(File file) throws FileNotFoundException, IOException
	{
		Properties prop = new Properties();
		try (FileInputStream in = new FileInputStream(file))
		{
			try (InputStreamReader reader = new InputStreamReader(in, "UTF-8"))
			{
				prop.load(reader);
				return prop;
			}
		}
	}
}
