package com.hp.hpl.sparta.xpath;


public class PositionEqualsExpr extends BooleanExpr {

  public PositionEqualsExpr(int position) {
    position_ = position;
  }

  public void accept(BooleanExprVisitor visitor) throws XPathException {
    visitor.visit(this);
  }

  public int getPosition() {
    return position_;
  }

  public String toString() {
    return "[" + position_ + "]";
  }

  private final int position_;
}

// $Log: PositionEqualsExpr.java,v $
// Revision 1.3  2002/12/13 18:08:30  eobrain
// Factor Visitor out into separate visitors for node tests and predicates.
//
// Revision 1.2  2002/12/06 23:41:49  eobrain
// Add toString() which returns the original XPath.
//
// Revision 1.1  2002/09/18 05:22:06  eobrain
// Support xpath predicates of the for [1], [2], ...
//
