/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pinyin4j.multipinyin;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import net.sourceforge.pinyin4j.multipinyin.MultiPinyinConfig;

public class Trie {
    private Hashtable<String, Trie> values = new Hashtable();
    private String pinyin;
    private Trie nextTire;

    public String getPinyin() {
        return this.pinyin;
    }

    public void setPinyin(String pinyin) {
        this.pinyin = pinyin;
    }

    public Trie getNextTire() {
        return this.nextTire;
    }

    public void setNextTire(Trie nextTire) {
        this.nextTire = nextTire;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load(InputStream inStream) throws IOException {
        BufferedReader bufferedReader = null;
        InputStreamReader inputStreamReader = null;
        try {
            String s;
            inputStreamReader = new InputStreamReader(inStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((s = bufferedReader.readLine()) != null) {
                String[] keyAndValue = s.split(" ");
                if (keyAndValue.length != 2) continue;
                Trie trie = new Trie();
                trie.pinyin = keyAndValue[1];
                this.put(keyAndValue[0], trie);
            }
        }
        finally {
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadMultiPinyin(InputStream inStream) throws IOException {
        BufferedReader bufferedReader = null;
        InputStreamReader inputStreamReader = null;
        try {
            String s;
            inputStreamReader = new InputStreamReader(inStream);
            bufferedReader = new BufferedReader(inputStreamReader);
            block3: while ((s = bufferedReader.readLine()) != null) {
                String[] keyAndValue = s.split(" ");
                if (keyAndValue.length != 2) continue;
                String key = keyAndValue[0];
                String value = keyAndValue[1];
                char[] keys = key.toCharArray();
                Trie currentTrie = this;
                for (int i = 0; i < keys.length; ++i) {
                    String hexString = Integer.toHexString(keys[i]).toUpperCase();
                    Trie trieParent = currentTrie.get(hexString);
                    if (trieParent == null) {
                        currentTrie.put(hexString, new Trie());
                        trieParent = currentTrie.get(hexString);
                    }
                    Trie trie = trieParent.getNextTire();
                    if (keys.length - 1 == i) {
                        trieParent.pinyin = value;
                        continue block3;
                    }
                    if (trie == null) {
                        if (keys.length - 1 == i) continue;
                        Trie subTrie = new Trie();
                        trieParent.setNextTire(subTrie);
                        subTrie.put(Integer.toHexString(keys[i + 1]).toUpperCase(), new Trie());
                        currentTrie = subTrie;
                        continue;
                    }
                    currentTrie = trie;
                }
            }
        }
        finally {
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
    }

    public void loadMultiPinyinExtend() throws IOException {
        File userMultiPinyinFile;
        String path = MultiPinyinConfig.multiPinyinPath;
        if (path != null && (userMultiPinyinFile = new File(path)).exists()) {
            this.loadMultiPinyin(new FileInputStream(userMultiPinyinFile));
        }
    }

    public Trie get(String hexString) {
        return this.values.get(hexString);
    }

    public void put(String s, Trie trie) {
        this.values.put(s, trie);
    }
}

