package com.hp.hpl.sparta.xpath;


public class TextExistsExpr extends BooleanExpr {

  //only need one of them => much memory sharing
  private TextExistsExpr() {}

  static final TextExistsExpr INSTANCE = new TextExistsExpr();


  public void accept(BooleanExprVisitor visitor) throws XPathException {
    visitor.visit(this);
  }

  public String toString() {
    return "[text()]";
  }

}

//$Log: TextExistsExpr.java,v $
//Revision 1.4  2002/12/13 22:42:22  eobrain
//Fix javadoc.
//
//Revision 1.3  2002/12/13 18:08:44  eobrain
//Factor Visitor out into separate visitors for node tests and predicates.
//
//Revision 1.2  2002/12/06 23:41:49  eobrain
//Add toString() which returns the original XPath.
//
//Revision 1.1  2002/10/30 16:25:20  eobrain
//Feature request [ 630127 ] Support /a/b[text()='foo']
//http://sourceforge.net/projects/sparta-xml/
//
