
package com.hp.hpl.sparta.xpath;

import com.hp.hpl.sparta.Sparta;


public class ElementTest extends NodeTest {

  ElementTest(String tagName) {
    tagName_ = Sparta.intern(tagName);
  }

  public void accept(Visitor visitor) {
    visitor.visit(this);
  }

  public boolean isStringValue() {
    return false;
  }

  public String getTagName() {
    return tagName_;
  }

  public String toString() {
    return tagName_;
  }

  private final String tagName_;
}

// $Log: ElementTest.java,v $
// Revision 1.5  2003/07/18 00:01:43  eobrain
// Make compatiblie with J2ME.  For example do not use "new"
// java.util classes.
//
// Revision 1.4  2003/05/12 20:54:55  eobrain
// Fix javadoc.
//
// Revision 1.3  2003/05/12 20:07:19  eobrain
// Performance improvement: intern strings.
//
// Revision 1.2  2002/12/06 23:41:49  eobrain
// Add toString() which returns the original XPath.
//
// Revision 1.1.1.1  2002/08/19 05:04:04  eobrain
// import from HP Labs internal CVS
//
// Revision 1.3  2002/08/18 23:38:36  eob
// Add copyright and other formatting and commenting in preparation for
// release to SourceForge.
//
// Revision 1.2  2002/06/14 19:39:52  eob
// Make test for isStringValue more object-oriented.  Avoid "instanceof".
//
// Revision 1.1  2002/02/01 01:43:54  eob
// initial
