
package net.sourceforge.pinyin4j;

import com.hp.hpl.sparta.Document;
import com.hp.hpl.sparta.Element;
import com.hp.hpl.sparta.ParseException;


class GwoyeuRomatzyhTranslator {

  static String convertHanyuPinyinToGwoyeuRomatzyh(String hanyuPinyinStr) {
    String pinyinString = TextHelper.extractPinyinString(hanyuPinyinStr);
    String toneNumberStr = TextHelper.extractToneNumber(hanyuPinyinStr);

    // return value
    String gwoyeuStr = null;
    try {
      // find the node of source Pinyin system
      String xpathQuery1 =
          "//" + PinyinRomanizationType.HANYU_PINYIN.getTagName() + "[text()='" + pinyinString
              + "']";

      Document pinyinToGwoyeuMappingDoc =
          GwoyeuRomatzyhResource.getInstance().getPinyinToGwoyeuMappingDoc();

      Element hanyuNode = pinyinToGwoyeuMappingDoc.xpathSelectElement(xpathQuery1);

      if (null != hanyuNode) {
        // find the node of target Pinyin system
        String xpathQuery2 =
            "../" + PinyinRomanizationType.GWOYEU_ROMATZYH.getTagName()
                + tones[Integer.parseInt(toneNumberStr) - 1] + "/text()";

          gwoyeuStr = hanyuNode.xpathSelectString(xpathQuery2);
      }
    } catch (ParseException e) {
      e.printStackTrace();
    }

    return gwoyeuStr;
  }


  static private String[] tones = new String[] {"_I", "_II", "_III", "_IV", "_V"};
}
