package com.hp.hpl.sparta;

import java.util.Hashtable;

public class Sparta
{

	static public String intern(String s)
	{
		return internment_.intern(s);
	}

	static public interface Internment
	{
		String intern(String s);
	}

	static public void setInternment(Internment i)
	{
		internment_ = i;
	}

	static private Internment internment_ = new Internment()
	{
		private final Hashtable strings_ = new Hashtable();

		public String intern(String s)
		{
			String ss = (String) strings_.get(s);
			if (ss == null)
			{
				strings_.put(s, s);
				return s;
			}
			else
				return ss;
		}
	};

	static public interface Cache
	{
		Object get(Object key);

		Object put(Object key, Object value);

		int size();
	}

	static public interface CacheFactory
	{
		Cache create();
	}

	static Cache newCache()
	{
		return cacheFactory_.create();
	}

	static public void setCacheFactory(CacheFactory f)
	{
		cacheFactory_ = f;
	}

	static private class HashtableCache extends Hashtable implements Cache
	{
	}

	static private CacheFactory cacheFactory_ = new CacheFactory()
	{
		public Cache create()
		{
			return new HashtableCache();
		}
	};
}
