package com.hp.hpl.sparta.xpath;


public abstract class TextCompareExpr extends BooleanExpr {
  TextCompareExpr(String value) {
    value_ = value;
  }

  public String getValue() {
    return value_;
  }

  protected String toString(String op) {
    return "[text()" + op + "\'" + value_ + "\']";
  }

  private final String value_;

}

// $Log: TextCompareExpr.java,v $
// Revision 1.2  2002/12/06 23:41:49  eobrain
// Add toString() which returns the original XPath.
//
// Revision 1.1  2002/10/30 16:17:59  eobrain
// initial
//
