package com.hp.hpl.sparta;

public class EncodingMismatchException extends ParseException {

  EncodingMismatchException(String systemId, String declaredEncoding, String assumedEncoding) {
    super(systemId, 0, declaredEncoding.charAt(declaredEncoding.length() - 1), declaredEncoding,
        "encoding \'" + declaredEncoding + "\' declared instead of of " + assumedEncoding
            + " as expected");
    declaredEncoding_ = declaredEncoding;
  }

  String getDeclaredEncoding() {
    return declaredEncoding_;
  }

  private String declaredEncoding_;

}


// $Log: EncodingMismatchException.java,v $
// Revision 1.1.1.1  2002/08/19 05:04:01  eobrain
// import from HP Labs internal CVS
//
// Revision 1.4  2002/08/18 04:35:44  eob
// Add copyright and other formatting and commenting in preparation for
// release to SourceForge.
//
// Revision 1.3  2002/08/05 20:04:32  sermarti
//
// Revision 1.2  2002/05/09 16:49:09  eob
// Add history arg.
//
// Revision 1.1  2002/01/08 19:25:38  eob
// initial
