package com.hp.hpl.sparta.xpath;


public class TextTest extends NodeTest {

  //only need one of them => GoF Flyweight Pattern(195) 
  private TextTest() {}

  static final TextTest INSTANCE = new TextTest();

  public void accept(Visitor visitor) throws XPathException {
    visitor.visit(this);
  }


  public boolean isStringValue() {
    return true;
  }

  public String toString() {
    return "text()";
  }
}

// $Log: TextTest.java,v $
// Revision 1.2  2002/12/06 23:39:35  eobrain
// Make objects that are always the same follow the Flyweight Pattern.
//
// Revision 1.1.1.1  2002/08/19 05:04:03  eobrain
// import from HP Labs internal CVS
//
// Revision 1.2  2002/08/18 23:39:05  eob
// Add copyright and other formatting and commenting in preparation for
// release to SourceForge.
//
// Revision 1.1  2002/06/14 19:33:21  eob
// initial
