
package net.sourceforge.pinyin4j;

import net.sourceforge.pinyin4j.multipinyin.Trie;

import java.io.FileNotFoundException;
import java.io.IOException;

class ChineseToPinyinResource
{

	private Trie unicodeToHanyuPinyinTable = null;

	private void setUnicodeToHanyuPinyinTable(Trie unicodeToHanyuPinyinTable)
	{
		this.unicodeToHanyuPinyinTable = unicodeToHanyuPinyinTable;
	}

	Trie getUnicodeToHanyuPinyinTable()
	{
		return unicodeToHanyuPinyinTable;
	}

	private ChineseToPinyinResource()
	{
		initializeResource();
	}

	private void initializeResource()
	{
		try
		{
			final String resourceName = "/pinyindb/unicode_to_hanyu_pinyin.txt";
			final String resourceMultiName = "/pinyindb/multi_pinyin.txt";

			setUnicodeToHanyuPinyinTable(new Trie());
			getUnicodeToHanyuPinyinTable().load(ResourceHelper.getResourceInputStream(resourceName));

			getUnicodeToHanyuPinyinTable().loadMultiPinyin(ResourceHelper.getResourceInputStream(resourceMultiName));

			getUnicodeToHanyuPinyinTable().loadMultiPinyinExtend();

		}
		catch (FileNotFoundException ex)
		{
			ex.printStackTrace();
		}
		catch (IOException ex)
		{
			ex.printStackTrace();
		}
	}

	Trie getHanyuPinyinTrie(char ch)
	{

		String codepointHexStr = Integer.toHexString((int) ch).toUpperCase();

		// fetch from hashtable
		return getUnicodeToHanyuPinyinTable().get(codepointHexStr);
	}

	String[] getHanyuPinyinStringArray(char ch)
	{
		String pinyinRecord = getHanyuPinyinRecordFromChar(ch);
		return parsePinyinString(pinyinRecord);
	}

	String[] parsePinyinString(String pinyinRecord)
	{

		if (null != pinyinRecord)
		{
			int indexOfLeftBracket = pinyinRecord.indexOf(Field.LEFT_BRACKET);
			int indexOfRightBracket = pinyinRecord.lastIndexOf(Field.RIGHT_BRACKET);

			String stripedString = pinyinRecord.substring(indexOfLeftBracket + Field.LEFT_BRACKET.length(), indexOfRightBracket);

			return stripedString.split(Field.COMMA);

		}
		else
			return null; // no record found or mal-formatted record
	}

	private boolean isValidRecord(String record)
	{
		final String noneStr = "(none0)";

		return (null != record) && !record.equals(noneStr) && record.startsWith(Field.LEFT_BRACKET) && record.endsWith(Field.RIGHT_BRACKET);
	}

	private String getHanyuPinyinRecordFromChar(char ch)
	{
		// convert Chinese character to code point (integer)
		// please refer to http://www.unicode.org/glossary/#code_point
		// Another reference: http://en.wikipedia.org/wiki/Unicode
		int codePointOfChar = ch;

		String codepointHexStr = Integer.toHexString(codePointOfChar).toUpperCase();

		// fetch from hashtable
		Trie trie = getUnicodeToHanyuPinyinTable().get(codepointHexStr);
		String foundRecord = null;
		if (trie != null) foundRecord = trie.getPinyin();

		return isValidRecord(foundRecord) ? foundRecord : null;
	}

	static ChineseToPinyinResource getInstance()
	{
		return ChineseToPinyinResourceHolder.theInstance;
	}

	private static class ChineseToPinyinResourceHolder
	{
		static final ChineseToPinyinResource theInstance = new ChineseToPinyinResource();
	}

	class Field
	{
		static final String LEFT_BRACKET = "(";

		static final String RIGHT_BRACKET = ")";

		static final String COMMA = ",";
	}
}
