

package net.sourceforge.pinyin4j;

import java.io.FileNotFoundException;
import java.io.IOException;

import com.hp.hpl.sparta.Document;
import com.hp.hpl.sparta.ParseException;
import com.hp.hpl.sparta.Parser;

class PinyinRomanizationResource {

  private Document pinyinMappingDoc;


  private void setPinyinMappingDoc(Document pinyinMappingDoc) {
    this.pinyinMappingDoc = pinyinMappingDoc;
  }

  Document getPinyinMappingDoc() {
    return pinyinMappingDoc;
  }


  private PinyinRomanizationResource() {
    initializeResource();
  }


  private void initializeResource() {
    try {
      final String mappingFileName = "/pinyindb/pinyin_mapping.xml";
      final String systemId = "";

      // Parse file to DOM Document
      setPinyinMappingDoc(Parser.parse(systemId, ResourceHelper
          .getResourceInputStream(mappingFileName)));

    } catch (FileNotFoundException ex) {
      ex.printStackTrace();
    } catch (IOException ex) {
      ex.printStackTrace();
    } catch (ParseException e) {
      e.printStackTrace();
    }
  }


  static PinyinRomanizationResource getInstance() {
    return PinyinRomanizationSystemResourceHolder.theInstance;
  }


  private static class PinyinRomanizationSystemResourceHolder {
    static final PinyinRomanizationResource theInstance = new PinyinRomanizationResource();
  }
}
